package com.bokesoft.yes.meta.persist.dom.excel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateConstants;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;

public class MetaExcelWorkbookAction extends BaseDomAction<MetaExcelWorkbook> {

	@Override
	public void load(Document document, Element element,
			MetaExcelWorkbook meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setNeedLoadData(DomHelper.readAttr(element, MetaExcelTemplateConstants.WORKBOOK_NEEDLOADDATA, false));
		meta.setFormKey(DomHelper.readAttr(element, MetaExcelTemplateConstants.WORKBOOK_FORMKEY, ""));
		meta.setNeedRestCellIndex(DomHelper.readAttr(element, MetaExcelTemplateConstants.WORKBOOK_NEEDRESETCELLINDEX, false));
	}

	@Override
	public void save(Document document, Element element,
			MetaExcelWorkbook meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.WORKBOOK_NEEDLOADDATA, meta.isNeedLoadData(), false);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.WORKBOOK_FORMKEY, meta.getFormKey(), "");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.WORKBOOK_NEEDRESETCELLINDEX, meta.isNeedResetCellIndex(), false);
	}
}
