package com.bokesoft.yes.meta.persist.dom.excel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelFont;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateConstants;

public class MetaExcelFontAction extends BaseDomAction<MetaExcelFont> {

	@Override
	public void load(Document document, Element element, MetaExcelFont meta, int runType) {
		meta.setName(DomHelper.readAttr(element, MetaExcelTemplateConstants.FONT_NAME, "宋体"));
		meta.setSize((short)DomHelper.readAttr(element, MetaExcelTemplateConstants.FONT_SIZE, 12));
		meta.setBold(DomHelper.readAttr(element, MetaExcelTemplateConstants.FONT_BOLD, false));
		meta.setItalic(DomHelper.readAttr(element, MetaExcelTemplateConstants.FONT_ITALIC, false));
	}

	@Override
	public void save(Document document, Element element, MetaExcelFont meta, int runType) {
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.FONT_NAME, meta.getName(), "宋体");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.FONT_SIZE, meta.getSize(), 12);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.FONT_BOLD, meta.isBold(), false);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.FONT_ITALIC, meta.isItalic(), false);
	}

}
