package com.bokesoft.yes.meta.persist.dom.entry;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaServiceRightsAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaServiceRightsCollectionAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.common.MetaServiceRights;
import com.bokesoft.yigo.meta.common.MetaServiceRightsCollection;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.entry.MetaEntryItem;

public class MetaEntryActionMap extends MetaActionMap {
	private MetaEntryActionMap() {
		super();
	}
	
	@Override
	protected Object[][] getActionLookupTable() {
		return new Object[][] {
				{ MetaEntry.TAG_NAME, new MetaEntryAction() },
				{ MetaEntryItem.TAG_NAME, new MetaEntryItemAction() },
				{ MetaConstants.Event_Action, new MetaBaseScriptAction<MetaBaseScript>()},
				{ MetaConstants.Event_OnClick, new MetaBaseScriptAction<MetaBaseScript>()},
				{ MetaServiceRightsCollection.TAG_NAME, new MetaServiceRightsCollectionAction()},
				{ MetaServiceRights.TAG_NAME, new MetaServiceRightsAction()} 
		};
	}

	private static MetaEntryActionMap instance = null;
	public static MetaEntryActionMap getInstance() {
		if ( instance == null ) {
			instance = new MetaEntryActionMap();
		}
		return instance;
	}

	@Override
	protected Object[][] getHostActionLookupTable() {
		return null;
	}
}
