package com.bokesoft.yes.meta.persist.dom.dataobject;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.*;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.datamigration.MetaDMConstants;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 *
 */
public class MetaDataObjectExtAction extends BaseDomAction<MetaDataObject> {
    public void load(Document doc, Element element, MetaDataObject meta, int runType) {
        meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
        meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, null));
        meta.setPrimaryType(DataObjectPrimaryType.parse(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_PRIMARYTYPE, DataObjectPrimaryType.STR_VIRTUAL)));
        meta.setSecondaryType(DataObjectSecondaryType.parse(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_SECONDARYTYPE, DataObjectSecondaryType.STR_NORMAL)));
        meta.setMainTableKey(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_PRIMATYTABLEKEY, null));
        meta.setNoPrefix(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_NOPREFIX, null));
        meta.setCustomNoPrefix(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_CUSTOMNOPREFIX, null));
        meta.setQueryColumns(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_QUERYFIELDS, null));
        meta.setDisplayColumns(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_DISPLAYFIELDS, null));
        meta.setMigrationUpdateStrategy(MigrationUpdateStrategyType.parse((DomHelper.readAttr(element, MetaDMConstants.UPDATE_STRATEGY, MigrationUpdateStrategyType.STR_INSERT_FAST))));
        meta.setIOProvider(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_IOPROVIDER, null));
        meta.setMaintainDict(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_MAINTAINDICT, true));
        meta.setRelateObjectKey(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_RELATE_OBJECT_KEY, null));
        meta.setAuthenticate(DomHelper.readBool(element, MetaConstants.AUTHENTICATE_FLAG, null));
        meta.setZeroPrefix(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_ZERO_PREFIX, -1));
        meta.setForbiddenLoad(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_FORBIDDEN_LOAD, false));
        meta.setForbiddenSave(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_FORBIDDEN_SAVE, false));
        meta.setForbiddenDelete(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_FORBIDDEN_DELETE, false));
        meta.setLoadRightsType(DataObjectLoadRightsType.parse(DomHelper.readAttr(element,
                MetaConstants.DATAOBJECT_LOAD_RIGHTS_TYPE, null)));
        meta.setCheckAfterLoad(DomHelper.readBool(element, MetaConstants.DATAOBJECT_CHECK_AFTER_LOAD, null));
        meta.setMigrationDeltaDBName(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_MIGRATION_DELTA_DBNAME, null));
        meta.setVersion(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_VERSION, 0));
        meta.setRollDataStrategy(RollDataStrategyType.parse(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_ROLLDATASTRATEGY, RollDataStrategyType.STR_NORMAL)));
        meta.setGlobalRightFilter(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_GLOBALRIGHTFILTER, null));
        meta.setMaintainSchema(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_MAINTAINSCHEMA, true));
        meta.setExtend(DomHelper.readAttr(element, MetaConstants.FORM_EXTEND, null));
		meta.setDictCacheCheckMode(DictCacheCheckMode.parse(DomHelper.readAttr(element, MetaConstants.DATAOBJECT_DICTCACHECHECKMODE, null)));
    }

    public void save(Document doc, Element element, MetaDataObject meta, int runType) {
        }
}
