package com.bokesoft.yes.meta.persist.dom.datamap.split;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.datamap.MetaMapConstants;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.datamap.split.MetaSplitGroup;

public class MetaSplitGroupAction extends BaseDomAction<MetaSplitGroup> {

	@Override
	public void load(Document document, Element element, MetaSplitGroup meta, int runType) {
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
		meta.setColumnKey(DomHelper.readAttr(element, MetaMapConstants.SPLIT_COLUMNKEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaSplitGroup meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
		DomHelper.writeAttr(element, MetaMapConstants.SPLIT_COLUMNKEY, meta.getColumnKey(), "");
	}

}
