package com.bokesoft.yes.meta.persist.dom.datamap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.datamap.source.FieldType;
import com.bokesoft.yigo.meta.datamap.target.MetaTargetField;

public class MetaTargetFieldAction extends BaseDomAction<MetaTargetField> {

	@Override
	public void load(Document document, Element element, MetaTargetField meta, int runType) {
		meta.setType(FieldType.parseType(DomHelper.readAttr(element, MetaMapConstants.FIELD_TYPE, FieldType.STR_FIELD)));
		meta.setDefinition(DomHelper.readAttr(element, MetaMapConstants.FIELD_DEFINITION, ""));
		meta.setCondition(DomHelper.readAttr(element, MetaMapConstants.FIELD_CONDITION, ""));
	}

	@Override
	public void save(Document document, Element element, MetaTargetField meta, int runType) {
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_TYPE, FieldType.formatTypeString(meta.getType()), FieldType.STR_FIELD);
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_DEFINITION, meta.getDefinition(), "");
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_CONDITION, meta.getCondition(), "");
	}

}
