package com.bokesoft.yes.meta.persist.dom.datamap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.datamap.source.FieldType;
import com.bokesoft.yigo.meta.datamap.target.MetaFeedback;

public class MetaFeedbackAction extends BaseDomAction<MetaFeedback> {

	@Override
	public void load(Document document, Element element, MetaFeedback meta, int runType) {
		meta.setDataObjectKey(DomHelper.readAttr(element, MetaMapConstants.FIELD_DATA_OBJECT_KEY, ""));
		meta.setTableKey(DomHelper.readAttr(element, MetaMapConstants.FIELD_TABLE_KEY, ""));
		meta.setFieldKey(DomHelper.readAttr(element, MetaMapConstants.FIELD_FIELD_KEY, ""));
		meta.setCondition(DomHelper.readAttr(element, MetaMapConstants.FIELD_CONDITION, ""));
		meta.setOpSign(FieldType.parseOpSign(DomHelper.readAttr(element, MetaMapConstants.FIELD_OP_SIGN, FieldType.STR_OP_ASSIGN)));
	}

	@Override
	public void save(Document document, Element element, MetaFeedback meta, int runType) {
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_DATA_OBJECT_KEY, meta.getDataObjectKey(), "");
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_TABLE_KEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_FIELD_KEY, meta.getFieldKey(), "");
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_CONDITION, meta.getCondition(), "");
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_OP_SIGN, FieldType.formatOpSignString(meta.getOpSign()), FieldType.STR_OP_ASSIGN);
	}

}
