package com.bokesoft.yes.meta.persist.dom.commondef;

import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;

import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementDef;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.solution.MetaProject;

/**
 * 数据元素目录扫描，返回MetaDataElementDef对象
 */
public class MetaDataElementFoldScanLoad extends BaseMetaScanLoad {
	private int runType = AppRunType.App;
	private MetaDataElementDef dataElementDef;

	private CopyOnWriteArrayList<MetaDataElementDef> list;
	public MetaDataElementFoldScanLoad(IMetaResolver resolver, MetaProject metaProject, Object context, int runType) {
		super(resolver, metaProject, DomMetaConstants.DATAELEMENT_FOLD, context);
		this.dataElementDef = new MetaDataElementDef();
		this.runType = runType;
		list = new CopyOnWriteArrayList<MetaDataElementDef>();
	}
	
	protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaDataMigrationProfile profile) {
		
	}
	
	private void merge() {
		if(list.isEmpty()) {
			return;
		}
		try {
			for(MetaDataElementDef meta: list) {
				this.dataElementDef.toMerge(meta);
			}
			
			MetaDataElementCollection dataElementCollection = this.dataElementDef.getDataElementCollection();
			if(dataElementCollection == null || dataElementCollection.isEmpty()) {
				return;
			}
			
			Iterator<MetaDataElement> it = dataElementCollection.iterator();
			MetaDataElement meta;
			while(it.hasNext()) {
				meta = it.next();
				meta.setProject(metaProject);
			}
		}finally {
			list.clear();
		}
	}
	
	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		MetaDataElementDefLoad load = new MetaDataElementDefLoad(AppRunType.App);
		load.load(resolver, filePath);
		MetaDataElementDef temp = (MetaDataElementDef) load.getRootMetaObject();
		if (temp != null) {
			MetaDataElementCollection dataElementCollection = temp.getDataElementCollection();
			if(dataElementCollection == null || dataElementCollection.isEmpty()) {
				return;
			}
			list.add(temp);
		}
	}

	public int getRunType() {
		return runType;
	}
	
	public MetaDataElementDef getMetaDataElementDef() {
		merge();
		return this.dataElementDef;
	}
}
