package com.bokesoft.yes.meta.persist.dom.bpm.action.node;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMessageSend;

public class MetaMessageSendAction extends MetaNodeAction<MetaMessageSend> {
	@Override
	public void load(Document doc, Element node, MetaMessageSend meta, int runType) {
		super.load(doc, node, meta, runType);
		meta.setReceiverID(DomHelper.readAttr(node, BPMConstants.MESSAGE_RECEIVER_ID, -1));	
	}
	
	@Override
	public void save(Document doc, Element node, MetaMessageSend meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, BPMConstants.MESSAGE_RECEIVER_ID, meta.getReceiverID(), -1);
	}
}
