package com.bokesoft.yes.meta.persist.dom.bpm.action.node;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.node.MetaComplexJoin;

public class MetaComplexJoinAction extends MetaNodeAction<MetaComplexJoin> {

	@Override
	public void load(Document doc, Element node, MetaComplexJoin meta, int runType) {
		super.load(doc, node, meta, runType);
		meta.setJoinCount(DomHelper.readAttr(node, BPMConstants.NODE_JOINCOUNT, -1));
		meta.setMateForkID(DomHelper.readAttr(node, BPMConstants.NODE_MATE_FORKID, -1));
	}

	@Override
	public void save(Document doc, Element node, MetaComplexJoin meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, BPMConstants.NODE_JOINCOUNT, meta.getJoinCount(), -1);
		DomHelper.writeAttr(node, BPMConstants.NODE_MATE_FORKID, meta.getMateForkID(), -1);
	}
}
