package com.bokesoft.yes.meta.persist.dom.bpm.action.node;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.node.MetaAnchor;

public class MetaAnchorAction extends MetaNodeAction<MetaAnchor> {

	@Override
	public void load(Document doc, Element node, MetaAnchor meta, int runType) {
		super.load(doc, node, meta, runType);
		meta.setStraightNodeID(DomHelper.readAttr(node, BPMConstants.NODE_STRAIGHT_NODE_ID, -1));
		meta.setStraightEmbedNodeID(DomHelper.readAttr(node, BPMConstants.NODE_STRAIGHT_EMBED_NODE_ID, -1));
	}
	
	@Override
	public void save(Document doc, Element node, MetaAnchor meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, BPMConstants.NODE_STRAIGHT_NODE_ID, meta.getStraightNodeID(), -1);
		DomHelper.writeAttr(node, BPMConstants.NODE_STRAIGHT_EMBED_NODE_ID, meta.getStraightEmbedNodeID(), -1);
	}
}
