package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMOperation;

public class MetaBPMOperationAction extends BaseDomAction<MetaBPMOperation> {

	@Override
	public void load(Document doc, Element node, MetaBPMOperation meta, int runType) {
		meta.setCaption(DomHelper.readAttr(node, BPMConstants.COMMON_CAPTION, ""));
		meta.setEnable(DomHelper.readAttr(node, BPMConstants.ELEMENT_ENABLE, "ReadOnly()"));
		meta.setIcon(DomHelper.readAttr(node, BPMConstants.ELEMENT_ICON, ""));
		meta.setKey(DomHelper.readAttr(node, BPMConstants.COMMON_KEY, ""));
		meta.setTemplateKey(DomHelper.readAttr(node, BPMConstants.NODE_TEMPLATEKEY, ""));
		meta.setVisible(DomHelper.readAttr(node, BPMConstants.ELEMENT_VISIBLE, ""));
		meta.setCssClass(DomHelper.readAttr(node, MetaConstants.OPERATION_CSSCLASS, ""));
	}

	@Override
	public void save(Document doc, Element node, MetaBPMOperation meta, int runType) {
		DomHelper.writeAttr(node, BPMConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(node, BPMConstants.ELEMENT_ENABLE, meta.getEnable(), "ReadOnly()");
		DomHelper.writeAttr(node, BPMConstants.ELEMENT_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(node, BPMConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_TEMPLATEKEY, meta.getTemplateKey(), "");
		DomHelper.writeAttr(node, BPMConstants.ELEMENT_VISIBLE, meta.getVisible(), "");
		DomHelper.writeAttr(node, MetaConstants.OPERATION_CSSCLASS, meta.getCssClass(), "");
	}

}
