/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.com.properties;

import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilter;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilterValue;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilter;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilterCollection;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaItemFilterCollectionJSONHandler
extends AbstractJSONHandler<MetaItemFilterCollection, DefaultSerializeContext> {
    @Override
    public void toJSONImpl(JSONObject json, MetaItemFilterCollection meta, DefaultSerializeContext hook) throws Throwable {
        for (MetaItemFilter itemFilter : meta) {
            json.put(itemFilter.getItemKey(), (Object)this.transItemFilter(itemFilter));
        }
    }

    private JSONArray transItemFilter(MetaItemFilter itemFilter) {
        JSONArray filters = new JSONArray();
        MetaFilter metaFilter = null;
        Iterator it = itemFilter.iterator();
        int i = 0;
        while (it.hasNext()) {
            metaFilter = (MetaFilter)it.next();
            filters.put((Object)this.transFilter(metaFilter, i++));
        }
        return filters;
    }

    private JSONObject transFilter(MetaFilter metaFilter, int index) {
        JSONObject filterJson = new JSONObject();
        filterJson.put("key", (Object)metaFilter.getKey());
        filterJson.put("type", (Object)metaFilter.getType());
        filterJson.put("cond", (Object)metaFilter.getCondition());
        filterJson.put("dependency", (Object)String.join((CharSequence)",", metaFilter.getDependedFields()));
        filterJson.put("filterIndex", index);
        JSONArray refValue = new JSONArray();
        JSONObject filterValueJson = null;
        int filterType = metaFilter.getType();
        for (MetaFilterValue fieldValue : metaFilter) {
            filterValueJson = new JSONObject();
            filterValueJson.put("type", (Object)fieldValue.getType());
            filterValueJson.put("dataType", (Object)fieldValue.getDataType());
            if (filterType == 0) {
                filterValueJson.put("refVal", (Object)fieldValue.getRefValueKey());
            } else if (filterType == 2) {
                filterValueJson.put("refVal", (Object)fieldValue.getParaValue());
            } else if (filterType == 3) {
                filterValueJson.put("refVal", (Object)fieldValue.getParaValue());
            }
            refValue.put((Object)filterValueJson);
        }
        filterJson.put("filterVals", (Object)refValue);
        return filterJson;
    }

    @Override
    public void fromJSONImpl(MetaItemFilterCollection meta, JSONObject json) throws Throwable {
        Set keySet = json.keySet();
        for (String itemKey : keySet) {
            MetaItemFilter itemFilter = this.unbuildItemFilter(json.optJSONArray(itemKey));
            itemFilter.setItemKey(itemKey);
            meta.add((AbstractMetaObject)itemFilter);
        }
    }

    private MetaItemFilter unbuildItemFilter(JSONArray array) {
        MetaItemFilter itemFilter = new MetaItemFilter();
        int size = array.length();
        for (int i = 0; i < size; ++i) {
            itemFilter.add((KeyPairMetaObject)this.unbuildFilter(array.optJSONObject(i)));
        }
        return itemFilter;
    }

    private MetaFilter unbuildFilter(JSONObject json) {
        MetaFilter filter = new MetaFilter();
        filter.setKey(json.optString("key"));
        filter.setType(Integer.valueOf(json.optInt("type")));
        filter.setCondition(json.optString("cond"));
        filter.setFilterDependency(json.optString("dependency"));
        int filterType = filter.getType();
        JSONArray array = json.optJSONArray("filterVals");
        int size = array.length();
        for (int i = 0; i < size; ++i) {
            JSONObject o = array.optJSONObject(i);
            MetaFilterValue filterValue = new MetaFilterValue();
            filterValue.setType(Integer.valueOf(o.optInt("type")));
            filterValue.setDataType(Integer.valueOf(o.optInt("dataType")));
            if (filterType == 0) {
                filterValue.setRefValue(o.optString("refVal"));
            } else if (filterType == 2) {
                filterValue.setParaValue(o.optString("refVal"));
            } else if (filterType == 3) {
                filterValue.setParaValue(o.optString("refVal"));
            }
            filter.add((KeyPairMetaObject)filterValue);
        }
        return filter;
    }

    @Override
    public MetaItemFilterCollection newInstance() {
        return new MetaItemFilterCollection();
    }
}

