/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.bpm;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaAssociation;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaDefaultSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaExceptionFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransitionCollection;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaTransitionCollectionJSONHandler
extends AbstractJSONHandler<MetaTransitionCollection, BPMSerializeContext> {
    @Override
    public void fromJSONImpl(MetaTransitionCollection meta, JSONObject json) throws Throwable {
        JSONArray array = json.optJSONArray("items");
        if (array != null) {
            int size = array.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                String tagName = jsonObject.optString("tagName");
                if ("SequenceFlow".equalsIgnoreCase(tagName)) {
                    meta.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaSequenceFlow.class, jsonObject));
                    continue;
                }
                if ("ExceptionFlow".equalsIgnoreCase(tagName)) {
                    meta.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaExceptionFlow.class, jsonObject));
                    continue;
                }
                if ("Association".equalsIgnoreCase(tagName)) {
                    meta.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaAssociation.class, jsonObject));
                    continue;
                }
                if (!"DefaultSequenceFlow".equalsIgnoreCase(tagName)) continue;
                meta.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaDefaultSequenceFlow.class, jsonObject));
            }
        }
    }

    @Override
    public void toJSONImpl(JSONObject json, MetaTransitionCollection meta, BPMSerializeContext hook) throws Throwable {
        JSONHelper.writeToJSON((JSONObject)json, (String)"tagName", (Object)meta.getTagName());
        JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, (GenericNoKeyCollection<? extends AbstractMetaObject>)meta);
        JSONHelper.writeToJSON((JSONObject)json, (String)"items", (Object)array);
    }

    @Override
    public MetaTransitionCollection newInstance() {
        return new MetaTransitionCollection();
    }
}

