/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.bpm;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.bpm.MetaNodeJSONHandler;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMOperation;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaDictionary;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaMidFormula;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaParticipatorCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaQuery;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelation;
import com.bokesoft.yigo.meta.bpm.process.node.MetaState;
import com.bokesoft.yigo.meta.bpm.process.node.MetaStateAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaStateActionJSONHandler
extends MetaNodeJSONHandler<MetaStateAction> {
    @Override
    public void fromJSONImpl(MetaStateAction meta, JSONObject json) throws Throwable {
        JSONArray array;
        super.fromJSONImpl(meta, json);
        meta.setDenyNodeKey(json.optString("denyNodeKey"));
        JSONObject o = json.optJSONObject("bpmOperation");
        if (o != null) {
            MetaBPMOperation operation = BPMJSONHandlerUtil.unbuild(MetaBPMOperation.class, o);
            meta.setOperation(operation);
        }
        if ((o = json.optJSONObject("batchOperation")) != null) {
            MetaBPMOperation batchOperation = BPMJSONHandlerUtil.unbuild(MetaBPMOperation.class, o);
            meta.setBatchOperation(batchOperation);
        }
        if ((o = json.optJSONObject("stateNode")) != null) {
            MetaState stateNode = BPMJSONHandlerUtil.unbuild(MetaState.class, o);
            meta.setStateNode(stateNode);
        }
        if ((array = json.optJSONArray("participatorCollection")) != null) {
            MetaParticipatorCollection participatorCollection = new MetaParticipatorCollection();
            int size = array.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                String tagName = jsonObject.optString("tagName");
                if ("Dictionary".equalsIgnoreCase(tagName)) {
                    participatorCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaDictionary.class, jsonObject));
                    continue;
                }
                if ("MidFormula".equalsIgnoreCase(tagName)) {
                    participatorCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaMidFormula.class, jsonObject));
                    continue;
                }
                if ("Query".equalsIgnoreCase(tagName)) {
                    participatorCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaQuery.class, jsonObject));
                    continue;
                }
                if ("Relation".equalsIgnoreCase(tagName)) {
                    participatorCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaRelation.class, jsonObject));
                    continue;
                }
                if (!"ExternalLink".equalsIgnoreCase(tagName)) continue;
                participatorCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaExternalLink.class, jsonObject));
            }
            meta.setParticipatorCollection(participatorCollection);
        }
    }

    @Override
    public void toJSONImpl(JSONObject json, MetaStateAction meta, BPMSerializeContext hook) throws Throwable {
        MetaParticipatorCollection participatorCollection;
        MetaState stateNode;
        MetaBPMOperation batchOperation;
        super.toJSONImpl(json, meta, hook);
        JSONHelper.writeToJSON((JSONObject)json, (String)"denyNodeKey", (Object)meta.getDenyNodeKey());
        MetaBPMOperation operation = meta.getOperation();
        if (operation != null) {
            JSONObject o = BPMJSONHandlerUtil.build((AbstractMetaObject)operation, hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"bpmOperation", (Object)o);
        }
        if ((batchOperation = meta.getBatchOperation()) != null) {
            JSONObject o = BPMJSONHandlerUtil.build((AbstractMetaObject)batchOperation, hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"batchOperation", (Object)o);
        }
        if ((stateNode = meta.getStateNode()) != null) {
            JSONObject o = BPMJSONHandlerUtil.build((AbstractMetaObject)stateNode, hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"stateNode", (Object)o);
        }
        if ((participatorCollection = meta.getParticipatorCollection()) != null) {
            JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, (GenericNoKeyCollection<? extends AbstractMetaObject>)participatorCollection);
            JSONHelper.writeToJSON((JSONObject)json, (String)"participatorCollection", (Object)array);
        }
    }

    @Override
    public MetaStateAction newInstance() {
        return new MetaStateAction();
    }
}

