/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.collection.operation;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.base.GenericKeyPairCompositeCollection;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.diff.MetaAdd;
import com.bokesoft.yigo.meta.diff.MetaDelete;
import com.bokesoft.yigo.meta.diff.collection.AbstractKeyPairTreeElementCollection;
import com.bokesoft.yigo.meta.diff.collection.operation.OperationElement;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElement;
import java.util.ArrayList;
import java.util.Iterator;

public class OperationElementCollection
extends AbstractKeyPairTreeElementCollection<KeyPairCompositeObject> {
    private MetaOperationCollection baseCollection = null;
    private OperationElement rootElement = null;

    public OperationElementCollection(MetaOperationCollection optCollection) {
        super(null);
        this.baseCollection = optCollection;
        this.rootElement = new OperationElement("", (KeyPairCompositeObject)optCollection, null, null);
        this.initMapOpts(this.baseCollection);
    }

    private void initMapOpts(MetaOperationCollection optCollection) {
        KeyPairCompositeObject opt = null;
        Iterator it = optCollection.iterator();
        OperationElement previousElement = null;
        while (it.hasNext()) {
            opt = (KeyPairCompositeObject)it.next();
            OperationElement element = new OperationElement(optCollection.getKey(), opt, previousElement, null);
            this.mapElements.put(opt.getKey(), element);
            if (previousElement != null) {
                previousElement.setNext(element);
            }
            previousElement = element;
            if (!(opt instanceof MetaOperationCollection)) continue;
            this.initMapOpts((MetaOperationCollection)opt);
        }
    }

    @Override
    public IKeyPairElement<KeyPairCompositeObject> getElement(String elementKey, String tagName) {
        if (StringUtil.isBlankOrNull((String)elementKey)) {
            return this.rootElement;
        }
        return (IKeyPairElement)this.mapElements.get(elementKey);
    }

    @Override
    public void addElement(MetaAdd metaAdd) {
        KeyPairCompositeObject meta = (KeyPairCompositeObject)metaAdd.getBase();
        Object previousElement = this.getElement(metaAdd.getPreviousKey(), null);
        IKeyPairElement<KeyPairCompositeObject> element = this.createKeyPairElement(meta, (IKeyPairElement<KeyPairCompositeObject>)previousElement, (IKeyPairElement<KeyPairCompositeObject>)null);
        ((OperationElement)element).setContainerKey(metaAdd.getContainerKey());
        if (previousElement != null) {
            OperationElement next = (OperationElement)previousElement.getNext();
            element.setNext(next);
            previousElement.setNext(element);
            if (next != null) {
                next.setPrevious(element);
            }
        }
        this.mapElements.put(element.getKey(), element);
        this.addMeta(meta.getKey(), meta, metaAdd.getPreviousKey(), metaAdd.getContainerKey());
    }

    @Override
    public IKeyPairElement<KeyPairCompositeObject> getContainer(IKeyPairElement<KeyPairCompositeObject> element) {
        String containerKey = element.getContainerKey();
        if (StringUtil.isBlankOrNull((String)containerKey)) {
            return this.rootElement;
        }
        return (IKeyPairElement)this.mapElements.get(containerKey);
    }

    @Override
    protected boolean addMeta(String key, KeyPairCompositeObject meta, String previousKey, String containerKey) {
        Object container = this.getElement(containerKey, "");
        MetaOperationCollection collection = null;
        collection = container == null ? this.baseCollection : (MetaOperationCollection)container.getMeta();
        collection.remove(meta.getKey());
        collection.add(meta);
        this.moveMeta(meta, collection, collection, previousKey);
        return true;
    }

    public void moveMeta(KeyPairCompositeObject meta, MetaOperationCollection oldContainer, MetaOperationCollection newContainer, String previousKey) {
        boolean finded = StringUtil.isBlankOrNull((String)previousKey);
        KeyPairCompositeObject tmp2 = null;
        ArrayList<KeyPairCompositeObject> listMove = new ArrayList<KeyPairCompositeObject>();
        listMove.add(meta);
        for (KeyPairCompositeObject tmp2 : newContainer) {
            if (finded && meta != tmp2) {
                listMove.add(tmp2);
            }
            if (finded) continue;
            finded = previousKey.equals(tmp2.getKey());
        }
        for (KeyPairCompositeObject item : listMove) {
            oldContainer.remove(item.getKey());
            newContainer.remove(item.getKey());
            newContainer.add(item);
        }
    }

    @Override
    public void deleteElement(MetaDelete metaDelete) {
        IKeyPairElement<KeyPairCompositeObject> conatainer;
        Object element = this.getElement(metaDelete.getKey(), metaDelete.getTagName());
        if (element != null && (conatainer = this.getContainer((IKeyPairElement<KeyPairCompositeObject>)element)) != null) {
            ((MetaOperationCollection)conatainer.getMeta()).remove(metaDelete.getKey());
        }
    }

    @Override
    protected IKeyPairElement<KeyPairCompositeObject> createKeyPairElement(KeyPairCompositeObject meta, IKeyPairElement<KeyPairCompositeObject> previous, IKeyPairElement<KeyPairCompositeObject> next) {
        return new OperationElement("", meta, previous, next);
    }

    @Override
    protected void remove4Collection(KeyPairCompositeObject meta) {
        Object element = this.getElement(meta.getKey(), null);
        IKeyPairElement<KeyPairCompositeObject> container = this.getContainer((IKeyPairElement<KeyPairCompositeObject>)element);
        if (container != null) {
            ((GenericKeyPairCompositeCollection)container.getMeta()).remove(meta.getKey());
        }
    }
}

