/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.collection.grid;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.diff.MetaAdd;
import com.bokesoft.yigo.meta.diff.collection.AbstractKeyPairTreeElementCollection;
import com.bokesoft.yigo.meta.diff.collection.grid.GridColumnElement;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElement;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumnCollection;
import java.util.Iterator;
import java.util.List;

public class GridColumnElementCollection
extends AbstractKeyPairTreeElementCollection<MetaGridColumn> {
    private MetaGridColumnCollection collection;

    public GridColumnElementCollection(MetaGridColumnCollection collection) {
        super(collection == null ? null : collection.iterator());
        this.collection = collection;
        this.init("", collection);
    }

    private void init(String parentKey, MetaGridColumnCollection columnCollection) {
        MetaGridColumn column = null;
        Iterator it = columnCollection.iterator();
        GridColumnElement previousElement = null;
        while (it.hasNext()) {
            column = (MetaGridColumn)it.next();
            GridColumnElement element = new GridColumnElement(parentKey, column, previousElement, null);
            this.mapElements.put(column.getKey(), element);
            if (previousElement != null) {
                previousElement.setNext(element);
            }
            previousElement = element;
            if (!column.hasChildren()) continue;
            this.init(column.getKey(), column.getColumnCollection());
        }
    }

    @Override
    public IKeyPairElement<MetaGridColumn> getContainer(IKeyPairElement<MetaGridColumn> element) {
        String containerKey = element.getContainerKey();
        if (StringUtil.isBlankOrNull((String)containerKey)) {
            return null;
        }
        return (IKeyPairElement)this.mapElements.get(containerKey);
    }

    @Override
    protected IKeyPairElement<MetaGridColumn> createKeyPairElement(MetaGridColumn meta, IKeyPairElement<MetaGridColumn> previous, IKeyPairElement<MetaGridColumn> next) {
        return new GridColumnElement("", meta, previous, next);
    }

    @Override
    protected void remove4Collection(MetaGridColumn meta) {
        Object element = this.getElement(meta.getKey(), null);
        IKeyPairElement<MetaGridColumn> container = this.getContainer((IKeyPairElement<MetaGridColumn>)element);
        if (container != null) {
            container.getMeta().getColumnCollection().remove((AbstractMetaObject)meta);
        } else {
            this.collection.remove((AbstractMetaObject)meta);
        }
    }

    @Override
    public void addElement(MetaAdd metaAdd) {
        MetaGridColumn meta = (MetaGridColumn)metaAdd.getBase();
        Object previousElement = this.getElement(metaAdd.getPreviousKey(), null);
        IKeyPairElement<MetaGridColumn> element = this.createKeyPairElement(meta, (IKeyPairElement<MetaGridColumn>)previousElement, (IKeyPairElement<MetaGridColumn>)null);
        ((GridColumnElement)element).setContainerKey(metaAdd.getContainerKey());
        if (previousElement != null) {
            GridColumnElement next = (GridColumnElement)previousElement.getNext();
            element.setNext(next);
            previousElement.setNext(element);
            if (next != null) {
                next.setPrevious(element);
            }
        }
        this.addMeta(meta.getKey(), meta, metaAdd.getPreviousKey(), metaAdd.getContainerKey());
        this.mapElements.put(element.getKey(), element);
    }

    @Override
    protected boolean addMeta(String key, MetaGridColumn meta, String previousKey, String containerKey) {
        Object container = this.getElement(containerKey, "");
        MetaGridColumnCollection collection = null;
        if (container == null) {
            collection = this.collection;
        } else {
            collection = ((MetaGridColumn)container.getMeta()).getColumnCollection();
            if (collection == null) {
                collection = new MetaGridColumnCollection();
                ((MetaGridColumn)container.getMeta()).setColumnCollection(collection);
            }
        }
        this.removeSourceIfExisted(key, collection.getList());
        collection.add((AbstractMetaObject)meta);
        this.moveMeta(meta, collection, collection, previousKey);
        return true;
    }

    @Override
    protected void removeSourceIfExisted(String key, List<MetaGridColumn> list) {
        if (list == null) {
            return;
        }
        MetaGridColumn find = null;
        for (MetaGridColumn item : list) {
            if (!key.equals(item.getKey())) continue;
            find = item;
        }
        if (find != null) {
            list.remove(find);
        }
    }

    public void moveMeta(MetaGridColumn meta, MetaGridColumnCollection oldContainer, MetaGridColumnCollection newContainer, String previousKey) {
        oldContainer.remove((AbstractMetaObject)meta);
        newContainer.remove((AbstractMetaObject)meta);
        GridColumnElement previousElement = (GridColumnElement)this.getElement(previousKey, null);
        if (StringUtil.isBlankOrNull((String)previousKey)) {
            newContainer.add(0, (AbstractMetaObject)meta);
        } else if (previousElement == null || newContainer.indexOf(previousElement.getMeta()) == -1) {
            newContainer.add((AbstractMetaObject)meta);
        } else {
            int index = newContainer.indexOf(previousElement.getMeta()) + 1;
            newContainer.add(index, (AbstractMetaObject)meta);
        }
    }
}

