/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.collection.component;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.diff.MetaAdd;
import com.bokesoft.yigo.meta.diff.MetaDelete;
import com.bokesoft.yigo.meta.diff.MetaMove;
import com.bokesoft.yigo.meta.diff.MetaMoveCollection;
import com.bokesoft.yigo.meta.diff.collection.component.ComponentElement;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElements;
import com.bokesoft.yigo.meta.form.MetaBlock;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Stack;

public class ComponentElementCollection
implements IKeyPairElements<ComponentElement> {
    private ComponentElement diffBlock = null;
    private HashMap<String, ComponentElement> mapComponent = null;

    public ComponentElementCollection(MetaBlock metaBlock) {
        this.diffBlock = new ComponentElement("", (MetaComponent)metaBlock, null, null);
        this.mapComponent = this.getAllUIComponents();
    }

    @Override
    public boolean containsKey(String componentKey, String tagName) {
        ComponentElement comp = this.getElement(componentKey, tagName);
        return comp != null;
    }

    @Override
    public boolean contains(ComponentElement element) {
        return this.containsKey(element.getKey(), element.getTagName());
    }

    @Override
    public ComponentElement getElement(String componentKey, String tagName) {
        if (StringUtil.isBlankOrNull((String)componentKey)) {
            return this.diffBlock;
        }
        ComponentElement diffComp = this.mapComponent.get(componentKey);
        if (diffComp == null || StringUtil.isBlankOrNull((String)tagName)) {
            return diffComp;
        }
        if (diffComp.checkTagName(tagName)) {
            return diffComp;
        }
        return null;
    }

    @Override
    public ComponentElement getContainer(ComponentElement diffComp) {
        String containerKey = diffComp.getContainerKey();
        if (StringUtil.isBlankOrNull((String)containerKey)) {
            return this.diffBlock;
        }
        return this.mapComponent.get(containerKey);
    }

    @Override
    public Collection<ComponentElement> getElementsList() {
        return this.mapComponent.values();
    }

    private HashMap<String, ComponentElement> getAllUIComponents() {
        LinkedHashMap<String, ComponentElement> componentMap = new LinkedHashMap<String, ComponentElement>();
        Stack<ComponentElement> stack = new Stack<ComponentElement>();
        stack.push(this.diffBlock);
        while (!stack.isEmpty()) {
            ComponentElement pop = (ComponentElement)stack.pop();
            if (!this.isBlock(pop.getMeta())) {
                componentMap.put(pop.getKey(), pop);
            }
            ComponentElement priviousComponent = null;
            int size = pop.getComponentCount();
            for (int i = 0; i < size; ++i) {
                if (pop.getChildComponent(i) == null) continue;
                ComponentElement child = new ComponentElement(pop.getKey(), pop.getChildComponent(i), priviousComponent, null);
                stack.add(child);
                if (priviousComponent != null) {
                    priviousComponent.setNext(child);
                }
                priviousComponent = child;
            }
        }
        return componentMap;
    }

    private boolean isBlock(Object meta) {
        return meta instanceof MetaBlock;
    }

    @Override
    public void addElement(MetaAdd metaAdd) {
        MetaComponent meta = (MetaComponent)metaAdd.getBase();
        ComponentElement element = new ComponentElement(metaAdd.getContainerKey(), meta, null, null);
        this.mapComponent.put(element.getKey(), element);
        if (StringUtil.isBlankOrNull((String)metaAdd.getContainerTag()) || "Block".equals(metaAdd.getContainerTag())) {
            ((MetaBlock)this.diffBlock.getMeta()).setRoot(meta);
        } else {
            ComponentElement container = this.getElement(metaAdd.getContainerKey(), null);
            if (container != null && container.getMeta() instanceof MetaPanel) {
                MetaPanel panel = (MetaPanel)container.getMeta();
                if (panel.containsComponent(meta.getKey())) {
                    panel.removeComponent(meta.getKey());
                }
                panel.addComponent(meta);
                this.moveMeta(element, container, container, metaAdd.getPreviousKey());
            }
        }
    }

    public void moveElement(MetaMove metaMove) {
        ComponentElement element = this.getElement(metaMove.getKey(), null);
        if (element == null) {
            return;
        }
        ComponentElement targetContainer = this.getElement(metaMove.getTargetContainerKey(), null);
        ComponentElement oldContainer = this.getContainer(element);
        this.moveMeta(element, oldContainer, targetContainer, metaMove.getPreviousKey());
    }

    private void removeMeta(ComponentElement oldContainer, ComponentElement element) {
        if (oldContainer.getMeta() instanceof MetaPanel) {
            MetaPanel sourcePanel = (MetaPanel)oldContainer.getMeta();
            sourcePanel.removeComponent(element.getKey());
        }
    }

    private void addMeta(ComponentElement targetContainer, ComponentElement element, String previousKey) {
        if (targetContainer.getMeta() instanceof MetaPanel) {
            MetaPanel newPanel = (MetaPanel)targetContainer.getMeta();
            MetaComponent preComponent = newPanel.getComponent(previousKey);
            int preIndex = newPanel.getComponentArray().indexOf(preComponent);
            if (preIndex >= 0) {
                newPanel.addComponent(preIndex + 1, element.getMeta());
            } else if (StringUtil.isBlankOrNull((String)previousKey)) {
                newPanel.addComponent(0, element.getMeta());
            } else {
                newPanel.addComponent(element.getMeta());
            }
        }
    }

    public void moveMeta(ComponentElement element, ComponentElement oldContainer, ComponentElement targetContainer, String previousKey) {
        this.removeMeta(oldContainer, element);
        this.addMeta(targetContainer, element, previousKey);
    }

    @Override
    public void deleteElement(MetaDelete metaDelete) {
        ComponentElement conatainer;
        ComponentElement element = this.getElement(metaDelete.getKey(), null);
        if (element != null && (conatainer = this.getContainer(element)) != null) {
            if ("Block".equals(conatainer.getTagName())) {
                ((MetaBlock)conatainer.getMeta()).setRoot(element.getMeta());
            } else {
                ((MetaPanel)conatainer.getMeta()).removeComponent(element.getMeta());
            }
        }
    }

    @Override
    public void moveElements(MetaMoveCollection moveCollection) {
    }
}

