/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.action.form;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.diff.MetaAdd;
import com.bokesoft.yigo.meta.diff.MetaDelete;
import com.bokesoft.yigo.meta.diff.MetaDiff;
import com.bokesoft.yigo.meta.diff.MetaDiffNode;
import com.bokesoft.yigo.meta.diff.MetaMoveCollection;
import com.bokesoft.yigo.meta.diff.action.AbstractMetaDiffAction;
import com.bokesoft.yigo.meta.diff.impl.IDiffContext;
import com.bokesoft.yigo.meta.diff.impl.IDiffMetaEnv;
import com.bokesoft.yigo.meta.diff.impl.IKeyPairElements;
import com.bokesoft.yigo.meta.diff.impl.IMergeDiffAction;
import com.bokesoft.yigo.meta.diff.util.CollectionUtil;
import com.bokesoft.yigo.meta.diff.util.MetaDiffUtil;
import com.bokesoft.yigo.meta.form.MetaUICheckRuleCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.form.component.grid.MetaRowExpand;
import com.bokesoft.yigo.meta.form.component.grid.MetaRowTree;

public class MetaGridRowDiffAction
extends AbstractMetaDiffAction<MetaGridRow> {
    @Override
    public boolean mergeDiffNode(final MetaGridRow baseMeta, MetaDiff metaDiff, MetaDiffNode metaDiffNode, IDiffContext context) throws Exception {
        final IKeyPairElements cellAll = CollectionUtil.trans2KeyPairElements(baseMeta);
        final IKeyPairElements checkRuleCollection = CollectionUtil.trans2KeyPairElements(baseMeta.getCheckRuleCollection());
        metaDiffNode.mergeDiff(new IMergeDiffAction(){

            public void mergeUpdate(AbstractMetaObject meta) {
                switch (meta.getTagName()) {
                    case "UICheckRuleCollection": {
                        baseMeta.setCheckRuleCollection((MetaUICheckRuleCollection)meta);
                        break;
                    }
                    case "RowExpand": {
                        baseMeta.setRowExpand((MetaRowExpand)meta);
                        break;
                    }
                    case "RowTree": {
                        baseMeta.setRowTree((MetaRowTree)meta);
                    }
                }
            }

            public void mergeDelete(MetaDelete meta) {
                switch (meta.getDeleteTag()) {
                    case "UICheckRule": {
                        checkRuleCollection.deleteElement(meta);
                        break;
                    }
                    case "GridCell": {
                        cellAll.deleteElement(meta);
                    }
                }
            }

            public void mergeAdd(MetaAdd meta) {
                switch (meta.getContainerTag()) {
                    case "UICheckRuleCollection": {
                        checkRuleCollection.addElement(meta);
                        break;
                    }
                    case "GridRow": 
                    case "GridCell": {
                        cellAll.addElement(meta);
                    }
                }
            }

            public boolean mergeMoveCollection(MetaMoveCollection moveCollection) {
                cellAll.moveElements(MetaMoveCollection.filterMoveCollectionByTags((MetaMoveCollection)moveCollection, (String[])new String[]{"GridCell"}));
                checkRuleCollection.moveElements(MetaMoveCollection.filterMoveCollectionByTags((MetaMoveCollection)moveCollection, (String[])new String[]{"UICheckRule"}));
                return true;
            }
        });
        return true;
    }

    @Override
    public void divideSubNode(MetaGridRow oldMeta, MetaGridRow newMeta, AbstractMetaObject oldParent, MetaDiffNode diffNode, MetaDiff metaDiff, IDiffContext context) throws Exception {
        MetaDiffUtil.diffKeyPairCollection(CollectionUtil.trans2KeyPairElements(oldMeta), CollectionUtil.trans2KeyPairElements(newMeta), diffNode, metaDiff, (AbstractMetaObject)oldMeta, null, context);
        MetaDiffUtil.diffKeyPairCollection(CollectionUtil.trans2KeyPairElements(oldMeta.getCheckRuleCollection()), CollectionUtil.trans2KeyPairElements(newMeta.getCheckRuleCollection()), diffNode, metaDiff, (AbstractMetaObject)oldMeta.getCheckRuleCollection(), (AbstractMetaObject)oldMeta, context);
        MetaDiffUtil.diffOnlyUpdate((AbstractMetaObject)oldMeta.getRowExpand(), (AbstractMetaObject)newMeta.getRowExpand(), diffNode, (IDiffMetaEnv)context.getEnv());
        MetaDiffUtil.diffOnlyUpdate((AbstractMetaObject)oldMeta.getRowTree(), (AbstractMetaObject)newMeta.getRowTree(), diffNode, (IDiffMetaEnv)context.getEnv());
    }
}

