/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.datamap.calculate;

import com.bokesoft.yes.parser.SyntaxTree;
import com.bokesoft.yes.struct.document.DocumentParser;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.datamap.source.MetaSourceField;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.util.ArrayList;

public class MapRowSelector {
    protected ArrayList<Long> OIDList;
    protected ArrayList<Long> SOIDList;
    protected ArrayList<String> mapKeyList;
    protected DocumentParser documentParser = null;
    private SyntaxTree syntaxTree = null;
    private Document doc = null;

    public MapRowSelector(Document document) {
        this.doc = document;
        this.OIDList = new ArrayList();
        this.SOIDList = new ArrayList();
        this.mapKeyList = new ArrayList();
    }

    public void selectRow(DataTable dataTable, int n, MetaSourceField metaSourceField) throws Throwable {
        this.OIDList.add(TypeConvertor.toLong((Object)dataTable.getObject(n, "OID")));
        this.SOIDList.add(TypeConvertor.toLong((Object)dataTable.getObject(n, "SOID")));
        if (metaSourceField != null) {
            this.mapKeyList.add(this.getMapKeyValue(dataTable, n, metaSourceField));
        }
    }

    public ArrayList<Long> getOIDList() {
        return this.OIDList;
    }

    public ArrayList<Long> getSOIDList() {
        return this.SOIDList;
    }

    public ArrayList<String> getMapKeyList() {
        return this.mapKeyList;
    }

    protected String getMapKeyValue(DataTable dataTable, int n, MetaSourceField metaSourceField) throws Throwable {
        Object object = null;
        if (metaSourceField.getType() == 0) {
            object = dataTable.getObject(n, metaSourceField.getDefinition());
        } else if (metaSourceField.getType() == 1) {
            object = this.eval(metaSourceField.getDefinition());
        } else if (metaSourceField.getType() == 2) {
            object = metaSourceField.getConstValue();
        }
        return TypeConvertor.toString((Object)object);
    }

    private Object eval(String string) throws Throwable {
        if (this.documentParser == null) {
            this.documentParser = new DocumentParser(this.doc, null);
            this.syntaxTree = this.documentParser.parser(string);
        }
        return this.documentParser.eval(this.syntaxTree);
    }
}

