/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.tools.json;

import com.bokesoft.yigo.common.json.JSONSerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONUtil {
    public static final int JSON_TYPE_ERROR = -1;
    public static final int JSON_TYPE_OBJECT = 0;
    public static final int JSON_TYPE_ARRAY = 1;

    public static boolean isJSONObject(String strJson) {
        int type = JSONUtil.getJSONType(strJson);
        return type == 0;
    }

    public static boolean isJSONArray(String strJson) {
        int type = JSONUtil.getJSONType(strJson);
        return type == 1;
    }

    public static int getJSONType(String strJson) {
        if (strJson == null || strJson.length() == 0) {
            return -1;
        }
        char firstChar = strJson.charAt(0);
        if (firstChar == '{') {
            return 0;
        }
        if (firstChar == '[') {
            return 1;
        }
        return -1;
    }

    public static String toJSON(Map<String, Object> params) throws Throwable {
        JSONObject jsonObject = JSONUtil.toJSONObject(params);
        return jsonObject.toString();
    }

    public static JSONObject toJSONObject(Map<String, Object> params) throws Throwable {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            if (param.getKey() == null || "".equals(param.getKey()) || param.getValue() == null || "".equals(param.getValue())) continue;
            jsonObject.put(param.getKey(), JSONUtil.convert(param.getValue()));
        }
        return jsonObject;
    }

    public static Map<String, Object> toMap(String jsonBody) throws Throwable {
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONObject obj = new JSONObject(jsonBody);
        Iterator it = obj.keys();
        Object value = null;
        while (it.hasNext()) {
            String key;
            Object o = it.next();
            if (!(o instanceof String) || (value = obj.get(key = (String)o)) == null) continue;
            params.put(key, JSONUtil.convert(value));
        }
        return params;
    }

    private static Object convert(Object object) throws Throwable {
        Object result = null;
        result = object instanceof JSONSerializable ? ((JSONSerializable)object).toJSON() : (object instanceof Collection ? JSONUtil.toJSONArray((Collection)object) : (object instanceof Map ? JSONUtil.toJSON((Map)object) : (object == null ? JSONObject.NULL : object)));
        return result;
    }

    public static JSONArray toJSONArray(Collection<?> collection) throws Throwable {
        if (collection == null) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        Iterator<?> iter = collection.iterator();
        Object value = null;
        while (iter.hasNext()) {
            value = iter.next();
            jsonArray.put(JSONUtil.convert(value));
        }
        return jsonArray;
    }

    public static List<Object> toList(JSONArray jsonArray) throws Throwable {
        if (jsonArray == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            list.add(jsonArray.get(i));
        }
        return list;
    }

    public static List<Long> toLongList(JSONArray jsonArray) throws Throwable {
        if (jsonArray == null) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            list.add(jsonArray.getLong(i));
        }
        return list;
    }

    public static List<Object> toList(String strJson) throws Throwable {
        if (!JSONUtil.isJSONArray(strJson)) {
            return null;
        }
        JSONArray jsonArray = new JSONArray(strJson);
        return JSONUtil.toList(jsonArray);
    }

    public static void toLongList(JSONArray jsonArray1, Class<?> class1) {
    }
}

