/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.tools.dic;

import com.bokesoft.yes.struct.dict.ItemRow;
import com.bokesoft.yes.struct.dict.ItemTableBase;
import com.bokesoft.yes.struct.dict.ItemTableMetaDatas;
import com.bokesoft.yes.tools.dic.item.DictMetaDatasFactory;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumnCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.solution.MetaLang;
import com.bokesoft.yigo.meta.solution.MetaLangConfig;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.dict.Item;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.dict.IDictCache;
import com.bokesoft.yigo.tools.ve.VE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class DictTools {
    private static List<String> langs = null;

    public static boolean checkStateMask(int stateMask, int enable) {
        boolean b = false;
        switch (enable) {
            case -1: {
                b = (stateMask & 4) != 0;
                break;
            }
            case 0: {
                b = (stateMask & 2) != 0;
                break;
            }
            case 1: {
                b = (stateMask & 1) != 0;
            }
        }
        return b;
    }

    public static PrepareSQL getEnableWhereClause(int stateMask, String colName) {
        PrepareSQL prepareSQL = new PrepareSQL();
        switch (stateMask) {
            case 7: {
                prepareSQL.setSQL("");
                return prepareSQL;
            }
            case 1: {
                prepareSQL.setSQL(colName + " = ?");
                prepareSQL.addValue(1);
                return prepareSQL;
            }
            case 2: {
                prepareSQL.setSQL(colName + " = ?");
                prepareSQL.addValue(0);
                return prepareSQL;
            }
            case 4: {
                prepareSQL.setSQL(colName + " = ?");
                prepareSQL.addValue(-1);
                return prepareSQL;
            }
        }
        String where = "";
        if ((stateMask & 1) != 0) {
            where = where + " OR " + colName + " = ?";
            prepareSQL.addValue(1);
        }
        if ((stateMask & 2) != 0) {
            where = where + " OR " + colName + " = ?";
            prepareSQL.addValue(0);
        }
        if ((stateMask & 4) != 0) {
            where = where + " OR " + colName + " = ?";
            prepareSQL.addValue(-1);
        }
        if (where.length() > 0) {
            where = where.substring(3);
            where = "(" + where.trim() + ")";
        }
        prepareSQL.setSQL(where);
        return prepareSQL;
    }

    public static JSONObject getDictCaption(VE ve, IDictCache dictCache, MetaForm metaForm, Document document) throws Throwable {
        Map<String, List<Long>> map = DictTools.getItemDatasInDoc(ve, metaForm, document);
        if (map.isEmpty()) {
            return null;
        }
        List<Long> oids = null;
        List<Item> items = null;
        JSONObject jsonObj = new JSONObject();
        for (String itemKey : map.keySet()) {
            oids = map.get(itemKey);
            items = dictCache.getItems(itemKey, oids);
            for (Item item : items) {
                jsonObj.put(item.toString(), (Object)item.getCaption());
            }
        }
        return jsonObj;
    }

    public static Map<String, List<Long>> getItemDatasInDoc(VE ve, MetaForm metaForm, Document document) throws Throwable {
        List<AbstractMetaObject> fields = DictTools.getDictFields(metaForm);
        MetaDataBinding metaDataBinding = null;
        int controlType = 0;
        MetaDictProperties dictProperties = null;
        String tableKey = null;
        String columnKey = null;
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        for (AbstractMetaObject metaObj : fields) {
            if (metaObj instanceof MetaListViewColumn) {
                controlType = ((MetaListViewColumn)metaObj).getColumnType();
                dictProperties = (MetaDictProperties)((MetaListViewColumn)metaObj).getProperties();
                columnKey = ((MetaListViewColumn)metaObj).getDataColumnKey();
                tableKey = ((MetaListViewColumn)metaObj).getTableKey();
            } else if (metaObj instanceof MetaEditViewColumn) {
                controlType = ((MetaEditViewColumn)metaObj).getColumnType();
                dictProperties = (MetaDictProperties)((MetaEditViewColumn)metaObj).getProperties();
                columnKey = ((MetaEditViewColumn)metaObj).getDataColumnKey();
                tableKey = ((MetaEditViewColumn)metaObj).getTableKey();
            } else if (metaObj instanceof MetaComponent) {
                metaDataBinding = ((MetaComponent)metaObj).getDataBinding();
                controlType = ((MetaComponent)metaObj).getControlType();
                dictProperties = (MetaDictProperties)((MetaComponent)metaObj).getProperties();
                columnKey = metaDataBinding.getColumnKey();
                tableKey = metaDataBinding.getTableKey();
            } else if (metaObj instanceof MetaGridCell) {
                metaDataBinding = ((MetaGridCell)metaObj).getDataBinding();
                controlType = ((MetaGridCell)metaObj).getCellType();
                dictProperties = (MetaDictProperties)((MetaGridCell)metaObj).getProperties();
                columnKey = metaDataBinding.getColumnKey();
                tableKey = ((MetaGridCell)metaObj).getTableKey();
            }
            DictTools.getDictData(document, map, controlType, dictProperties, tableKey, columnKey);
        }
        return map;
    }

    private static List<AbstractMetaObject> getDictFields(MetaForm metaForm) {
        ArrayList<AbstractMetaObject> fields = new ArrayList<AbstractMetaObject>();
        List comps = metaForm.getAllComponents();
        MetaDataBinding metaDataBinding = null;
        for (MetaComponent comp : comps) {
            MetaListViewColumnCollection columnCollection;
            int controlType = comp.getControlType();
            if (controlType == 206 || controlType == 242 || controlType == 241) {
                metaDataBinding = comp.getDataBinding();
                if (metaDataBinding == null || metaDataBinding.getColumnKey() == null || metaDataBinding.getColumnKey().isEmpty()) continue;
                fields.add((AbstractMetaObject)comp);
                continue;
            }
            if (controlType == 216) {
                columnCollection = ((MetaListView)comp).getColumnCollection();
                for (MetaListViewColumn column : columnCollection) {
                    if (column.getColumnType() != 206 || column.getDataColumnKey() == null || column.getDataColumnKey().isEmpty()) continue;
                    fields.add((AbstractMetaObject)column);
                }
                continue;
            }
            if (controlType != 305) continue;
            columnCollection = ((MetaEditView)comp).getColumnCollection();
            for (MetaListViewColumn column : columnCollection) {
                if (column.getColumnType() != 206 || column.getDataColumnKey() == null || column.getDataColumnKey().isEmpty()) continue;
                fields.add((AbstractMetaObject)column);
            }
        }
        List cells = metaForm.getAllGridCells();
        for (MetaGridCell cell : cells) {
            int controlType = cell.getCellType();
            if (controlType != 206 && controlType != 242 && controlType != 241 || (metaDataBinding = cell.getDataBinding()) == null || metaDataBinding.getColumnKey() == null || metaDataBinding.getColumnKey().isEmpty()) continue;
            fields.add((AbstractMetaObject)cell);
        }
        return fields;
    }

    private static void getDictData(Document document, Map<String, List<Long>> map, int controlType, MetaDictProperties dictProperties, String tableKey, String columnKey) {
        DataTable table = document.get(tableKey);
        if (table == null) {
            return;
        }
        int colIndex = table.getMetaData().findColumnIndexByKey(columnKey);
        if (colIndex == -1) {
            return;
        }
        String itemKey = null;
        if (table.first()) {
            while (!table.isAfterLast()) {
                Object value = table.getObject(colIndex);
                if (value == null) {
                    table.next();
                    continue;
                }
                switch (controlType) {
                    case 206: {
                        itemKey = dictProperties.getItemKey();
                        break;
                    }
                    case 241: 
                    case 242: {
                        int col = table.getMetaData().findColumnIndexByKey(columnKey + "ItemKey");
                        itemKey = col != -1 ? table.getString(col) : "";
                    }
                }
                if (itemKey != null && !itemKey.isEmpty()) {
                    if (dictProperties.isAllowMultiSelection().booleanValue()) {
                        Long[] oids;
                        String ids = TypeConvertor.toString((Object)value);
                        if (ids.length() > 0 && (oids = TypeConvertor.toLongArray((Object)ids.split(","))).length > 0) {
                            for (Long oid : oids) {
                                DictTools.addDictItems(map, itemKey, oid);
                            }
                        }
                    } else {
                        long oid = TypeConvertor.toLong((Object)value);
                        DictTools.addDictItems(map, itemKey, oid);
                    }
                }
                table.next();
            }
        }
    }

    private static void addDictItems(Map<String, List<Long>> map, String itemKey, Long oid) {
        if (itemKey != null && !itemKey.isEmpty() && oid > 0L) {
            List<Long> oids;
            if (!map.containsKey(itemKey)) {
                map.put(itemKey, new ArrayList());
            }
            if (!(oids = map.get(itemKey)).contains(oid)) {
                oids.add(oid);
            }
        }
    }

    public static Item toI18nData(VE ve, Item item) throws Throwable {
        if (item == null) {
            return null;
        }
        if (!ve.getMetaFactory().getSolution().isEnableMultiLang().booleanValue()) {
            return item;
        }
        if (item.getID() == 0L) {
            return item;
        }
        if (item.getIsInitI18n()) {
            return item;
        }
        String locale = ve.getEnv().getLocale();
        MetaLangConfig langConfig = ve.getMetaFactory().getSolution().getLangConfig();
        MetaLang lang = (MetaLang)langConfig.get(locale);
        if (lang == null) {
            return item;
        }
        if (langs == null) {
            langs = new ArrayList<String>();
            for (MetaLang l : langConfig) {
                langs.add(l.getKey());
            }
        }
        item.setInitI18n();
        String suffix = lang.getKey();
        String itemKey = item.getItemKey();
        ItemTableMetaDatas itemMetaDatas = DictMetaDatasFactory.getInstance().getDictMetaDatas(ve, itemKey);
        Map map = itemMetaDatas.getI18nColumns();
        MetaDataObject dataObj = ve.getMetaFactory().getDataObject(itemKey);
        if (!map.isEmpty()) {
            return DictTools.toI18nData(item, suffix, map, dataObj.getDisplayColumns());
        }
        return item;
    }

    public static List<Item> toI18nDatas(VE ve, List<Item> items) throws Throwable {
        if (items == null) {
            return null;
        }
        if (!ve.getMetaFactory().getSolution().isEnableMultiLang().booleanValue()) {
            return items;
        }
        ArrayList<Item> list = new ArrayList<Item>();
        for (Item item : items) {
            list.add(DictTools.toI18nData(ve, item));
        }
        return list;
    }

    private static Item toI18nData(Item item, String suffix, Map<String, List<String>> i18nColumns, List<MetaColumn> displayFields) {
        Item clone = item;
        clone.setI18nColumns(i18nColumns);
        for (String tableKey : i18nColumns.keySet()) {
            ItemTableBase itb = clone.getItemTable(tableKey);
            ItemTableBase itb_t = clone.getItemTable(tableKey + "_T");
            if (itb == null || itb_t == null || itb.isLang()) continue;
            List<String> keys = i18nColumns.get(tableKey);
            for (String key : keys) {
                for (ItemRow row : itb.getRows()) {
                    Object value = null;
                    for (ItemRow row_t : itb_t.getRows()) {
                        if (suffix.equals(row_t.getValue("Lang")) && row_t.getValue("SrcLangOID").equals(row.getValue("OID"))) {
                            value = row_t.getValue(key);
                        }
                        Object tmpValue = null;
                        Object tmpLang = null;
                        if (row_t.getValue("SrcLangOID").equals(row.getValue("OID"))) {
                            tmpValue = row_t.getValue(key);
                            tmpLang = row_t.getValue("Lang");
                        }
                        if (tmpValue == null) {
                            tmpValue = ((ItemRow)itb_t.getRows().get(0)).getValue(key);
                        }
                        if (tmpValue == null || tmpLang == null) continue;
                        row.setValue(key + "#" + tmpLang, tmpValue);
                        item.addI18nValue(tableKey, key, tmpValue, TypeConvertor.toString((Object)tmpLang));
                    }
                    if (value == null) {
                        value = ((ItemRow)itb_t.getRows().get(0)).getValue(key);
                    }
                    if (value == null) continue;
                    row.setValue(key, value);
                }
            }
            itb.setLang(true);
        }
        DictTools.initI18nCaption(clone, displayFields);
        return clone;
    }

    private static void initI18nCaption(Item item, List<MetaColumn> displayFields) {
        block10: {
            StringBuilder sb;
            block8: {
                MetaColumn metaColumn;
                int i;
                block9: {
                    sb = null;
                    if (displayFields == null || displayFields.size() <= 0) break block8;
                    boolean supportI18n = false;
                    for (i = 0; i < displayFields.size(); ++i) {
                        metaColumn = displayFields.get(i);
                        if (!metaColumn.isSupportI18n().booleanValue()) continue;
                        supportI18n = true;
                    }
                    if (!supportI18n || langs == null) break block9;
                    for (String suffix : langs) {
                        sb = new StringBuilder();
                        for (int i2 = 0; i2 < displayFields.size(); ++i2) {
                            MetaColumn metaColumn2 = displayFields.get(i2);
                            if (i2 > 0) {
                                sb.append(" ");
                            }
                            Object value = null;
                            value = metaColumn2.isSupportI18n() != false ? item.getI18nValue(metaColumn2.getKey(), suffix) : item.getValue(metaColumn2.getKey());
                            sb.append(TypeConvertor.toString((Object)value));
                        }
                        if (sb == null) continue;
                        String caption = sb.toString();
                        item.addI18nCaption(suffix, caption);
                    }
                    break block10;
                }
                sb = new StringBuilder();
                for (i = 0; i < displayFields.size(); ++i) {
                    metaColumn = displayFields.get(i);
                    if (i > 0) {
                        sb.append(" ");
                    }
                    String key = metaColumn.getKey();
                    Object value = item.getValue(key);
                    sb.append(TypeConvertor.toString((Object)value));
                }
                if (sb == null) break block10;
                String caption = sb.toString();
                item.setCaption(caption);
                break block10;
            }
            if (langs != null) {
                for (String suffix : langs) {
                    sb = new StringBuilder();
                    Object value = item.getI18nValue("Name", suffix);
                    sb.append(TypeConvertor.toString((Object)item.getValue("Code"))).append(" ").append(TypeConvertor.toString((Object)value));
                    String caption = sb.toString();
                    item.addI18nCaption(suffix, caption);
                }
            }
        }
    }
}

