/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.service.cmd;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.engine.node.ExecUserTask;
import com.bokesoft.yes.bpm.service.cmd.BPMServiceCmd;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.WorkitemUtil;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.TypeConvertor;

public class RefuseTaskCmd
extends BPMServiceCmd {
    private long workitemID;
    private int auditResult;
    private String userInfo = "";

    public RefuseTaskCmd() {
    }

    public RefuseTaskCmd(long l2) {
        this.workitemID = l2;
    }

    public IServiceCmd<BPMContext> newInstance() {
        return new RefuseTaskCmd();
    }

    @Override
    public void dealArguments(BPMContext bPMContext, StringHashMap<Object> stringHashMap) throws Throwable {
        this.workitemID = TypeConvertor.toLong((Object)stringHashMap.get((Object)"workitemID"));
        this.auditResult = TypeConvertor.toInteger((Object)stringHashMap.get((Object)"auditResult"));
        this.userInfo = TypeConvertor.toString((Object)stringHashMap.get((Object)"userInfo"));
    }

    @Override
    public Object doCmd(BPMContext bPMContext) throws Throwable {
        Workitem workitem = WorkitemUtil.loadWorkitem(bPMContext, (Long)this.workitemID);
        if (workitem == null) {
            return "";
        }
        bPMContext = BPMContext.getBPMContext(bPMContext, workitem.getInstanceID());
        workitem.setAuditResult(this.auditResult);
        workitem.setUserInfo(this.userInfo);
        bPMContext.setUpdateWorkitem(workitem);
        BPMInstance bPMInstance = BPMInstanceFactory.getBPMInstance(bPMContext, workitem.getInstanceID());
        if (bPMInstance.getInstanceData().getInstance().getData().getInstanceState() == 4) {
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)23, (Object[])new Object[0]);
        }
        if (bPMInstance != null) {
            ((ExecUserTask)bPMInstance.getNodeByID(workitem.getInlineNodeID(), workitem.getNodeID())).refuseTask(bPMContext);
        }
        bPMContext.getInstanceDataContainer().save();
        return "";
    }

    public void setWorkitemID(long l2) {
        this.workitemID = l2;
    }

    public void setAuditResult(int n2) {
        this.auditResult = n2;
    }

    public void setUserInfo(String string) {
        this.userInfo = string;
    }

    @Override
    public String getCmd() {
        return "RefuseTask";
    }
}

