/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.engine.node;

import com.bokesoft.yes.bpm.engine.data.virtual.table.VTToken;
import com.bokesoft.yes.bpm.engine.instance.VirtualInstance;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.message.DefaultIdGenerator;
import com.bokesoft.yes.bpm.message.MessageSend;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.gop.bpm.IExecutionContext;
import com.bokesoft.yes.gop.bpm.handler.IMessageSendHandler;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.bpm.common.IMessageGenerator;
import com.bokesoft.yigo.bpm.common.IMessageSend;
import com.bokesoft.yigo.bpm.message.BasicInfo;
import com.bokesoft.yigo.bpm.message.HeadInfo;
import com.bokesoft.yigo.meta.bpm.process.message.MetaMessage;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMessageSend;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.tools.ve.VE;
import org.json.JSONObject;

public class ExecMessageSend
extends ExecNode
implements IMessageSendHandler {
    private MetaMessageSend metaNode = null;

    public ExecMessageSend(VirtualInstance virtualInstance, MetaNode metaNode) {
        super(virtualInstance, metaNode);
        this.metaNode = (MetaMessageSend)metaNode;
    }

    @Override
    public void sendMessage(IExecutionContext iExecutionContext) throws Throwable {
        boolean bl = false;
        BPMContext bPMContext = (BPMContext)iExecutionContext;
        for (MetaMessage metaMessage : this.metaNode.getMessageCollection()) {
            int n2;
            int n3;
            Object object = metaMessage.getSendImpl();
            String string = metaMessage.getDestination();
            if (StringUtil.isBlankOrNull((String)object)) {
                object = StringUtil.isBlankOrNull((String)metaMessage.getGeneratorImpl()) ? this.generateMessage(bPMContext, metaMessage) : ((IMessageGenerator)ReflectHelper.newInstance((VE)iExecutionContext.getVE(), (String)metaMessage.getGeneratorImpl())).generate(bPMContext, metaMessage, this.instance, (MetaNode)this.metaNode);
                try {
                    new MessageSend(string).send((String)object);
                    bl = true;
                    continue;
                }
                catch (Throwable throwable) {
                    for (n3 = 0; n3 < metaMessage.getResendTimes(); ++n3) {
                        try {
                            new MessageSend(string).send((String)object);
                            bl = true;
                            continue;
                        }
                        catch (Throwable throwable2) {
                            n2 = n3 + 1;
                            System.out.println(n2 + " times resend fail");
                        }
                    }
                    continue;
                }
            }
            object = (IMessageSend)ReflectHelper.newInstance((VE)bPMContext.getVE(), (String)object);
            try {
                object.send(bPMContext, metaMessage, this.getID());
                bl = true;
            }
            catch (Throwable throwable) {
                for (n3 = 0; n3 < metaMessage.getResendTimes(); ++n3) {
                    try {
                        object.send(bPMContext, metaMessage, this.getID());
                        bl = true;
                        continue;
                    }
                    catch (Throwable throwable3) {
                        n2 = n3 + 1;
                        System.out.println(n2 + " times resend fail");
                    }
                }
            }
        }
        if (bl) {
            this.output(bPMContext);
            return;
        }
        BPMContext bPMContext2 = bPMContext;
        this.instance.getBPMInstance().getInstanceData().rollbackToWorkitem(bPMContext2, bPMContext2.getUpdateWorkitemID(), Boolean.FALSE);
        bPMContext.getInstanceDataContainer().save();
    }

    private String generateMessage(BPMContext bPMContext, MetaMessage object) throws Throwable {
        bPMContext = new JSONObject();
        Object object2 = this.generateID();
        HeadInfo headInfo = new HeadInfo();
        headInfo.setTag("yigo-bpm");
        headInfo.setId((String)object2);
        headInfo.setTimestamp(System.currentTimeMillis());
        object2 = headInfo.toJSON();
        bPMContext.put("bpm-head", object2);
        object2 = new BasicInfo();
        ((BasicInfo)object2).setInstanceID(this.instance.getInstanceID());
        ((BasicInfo)object2).setInlineNodeID(this.instance.getInstanceData().getInlineNodeID());
        ((BasicInfo)object2).setSourceNodeID(this.getID());
        if (this.metaNode.getReceiverID() > 0) {
            ((BasicInfo)object2).setTargetNodeID(this.metaNode.getReceiverID());
        }
        if ((object2 = ((BasicInfo)object2).toJSON()) != null) {
            bPMContext.put("bpm-basic", object2);
        }
        if (!StringUtil.isBlankOrNull((String)(object = object.getDefaultMessage()))) {
            bPMContext.put("bpm-user-msg", object);
        }
        return bPMContext.toString();
    }

    private String generateID() {
        return new DefaultIdGenerator().generateID().toString();
    }

    public void dealWithTokenInLeave(IExecutionContext iExecutionContext) throws Throwable {
        BPMContext bPMContext = (BPMContext)iExecutionContext;
        VTToken vTToken = this.instance.getInstanceData().getToken();
        vTToken.deleteTokenByNodeID(this.getID(), iExecutionContext.getDBManager());
        int n2 = this.instance.applyNewTokenID();
        vTToken.createNewToken(n2, 0);
        bPMContext.setActiveTokenID(n2);
    }
}

