/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.engine.data.table;

import com.bokesoft.yes.bpm.engine.data.OIDRef;
import com.bokesoft.yes.bpm.engine.data.row.RLog;
import com.bokesoft.yes.bpm.engine.data.table.BPMTable;
import com.bokesoft.yes.bpm.workitem.data.RWorkitem;
import com.bokesoft.yes.bpm.workitem.data.SqlHelper;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.util.ArrayList;
import java.util.List;

public class TLog
extends BPMTable<RLog> {
    @Override
    public String getDeleteSql(IDBManager iDBManager) {
        return "delete  from  " + iDBManager.keyWordEscape("BPM_Log") + " where " + iDBManager.keyWordEscape("InstanceID") + "=? and " + iDBManager.keyWordEscape("LogID") + "=?";
    }

    @Override
    public String getDataSourceSql(IDBManager iDBManager) {
        return "select * from  " + iDBManager.keyWordEscape("BPM_Log") + " where " + iDBManager.keyWordEscape("InstanceID") + "=?";
    }

    @Override
    public String getInsertSql(IDBManager iDBManager) {
        return "insert into  " + iDBManager.keyWordEscape("BPM_Log") + "  (" + iDBManager.keyWordEscape("InstanceID") + "," + iDBManager.keyWordEscape("OID") + "," + iDBManager.keyWordEscape("LogID") + "," + iDBManager.keyWordEscape("LogIndex") + "," + iDBManager.keyWordEscape("InlineNodeID") + "," + iDBManager.keyWordEscape("NodeID") + "," + iDBManager.keyWordEscape("WorkitemID") + "," + iDBManager.keyWordEscape("WorkitemName") + "," + iDBManager.keyWordEscape("WorkitemState") + "," + iDBManager.keyWordEscape("CreateTime") + "," + iDBManager.keyWordEscape("FinishTime") + "," + iDBManager.keyWordEscape("OperatorID") + "," + iDBManager.keyWordEscape("AuditResult") + "," + iDBManager.keyWordEscape("UserInfo") + "," + iDBManager.keyWordEscape("ResultInfo") + "," + iDBManager.keyWordEscape("LaunchInfo") + "," + iDBManager.keyWordEscape("TransactionID") + "," + iDBManager.keyWordEscape("AssistTransactionID") + "," + iDBManager.keyWordEscape("ParentWorkitemID") + ") values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    }

    @Override
    public String getUpdateSql(IDBManager iDBManager) {
        return "update  " + iDBManager.keyWordEscape("BPM_Log") + "  set " + iDBManager.keyWordEscape("LogIndex") + "=?," + iDBManager.keyWordEscape("WorkitemState") + "=?," + iDBManager.keyWordEscape("FinishTime") + "=?," + iDBManager.keyWordEscape("OperatorID") + "=?," + iDBManager.keyWordEscape("UserInfo") + "=?," + iDBManager.keyWordEscape("ResultInfo") + "=?," + iDBManager.keyWordEscape("LaunchInfo") + "=?," + iDBManager.keyWordEscape("AuditResult") + "=?," + iDBManager.keyWordEscape("AssistTransactionID") + "=?  where " + iDBManager.keyWordEscape("InstanceID") + "=? and " + iDBManager.keyWordEscape("LogID") + "=?";
    }

    @Override
    protected String getDeleteAllSql(IDBManager iDBManager) {
        return "delete from " + iDBManager.keyWordEscape("BPM_Log") + "  where " + iDBManager.keyWordEscape("InstanceID") + "=?";
    }

    public TLog(Long l2, OIDRef oIDRef) {
        super(l2, oIDRef);
    }

    public QueryArguments getDeletePSArgs(IDBManager iDBManager, RLog rLog) throws Throwable {
        PSArgs pSArgs = new PSArgs();
        SqlHelper.dealInstanceID2ConditionArge(iDBManager, this.instanceID, this.OID, pSArgs);
        pSArgs.addIntArg(rLog.getLogID());
        return pSArgs;
    }

    public QueryArguments getUpdatePSArgs(IDBManager iDBManager, RLog rLog) throws Throwable {
        PSArgs pSArgs = new PSArgs();
        pSArgs.addIntArg(rLog.getLogIndex());
        pSArgs.addIntArg(rLog.getWorkitemState());
        pSArgs.addTimestampArg(rLog.getFinishTime());
        pSArgs.addLongArg(rLog.getOperatorID());
        pSArgs.addStringArg(rLog.getUserInfo());
        pSArgs.addStringArg(rLog.getResultInfo());
        pSArgs.addStringArg(rLog.getLaunchInfo());
        pSArgs.addIntArg(Integer.valueOf(rLog.getAuditResult()));
        pSArgs.addIntArg(rLog.getAssistTransactionID());
        SqlHelper.dealInstanceID2ConditionArge(iDBManager, this.instanceID, this.OID, pSArgs);
        pSArgs.addIntArg(rLog.getLogID());
        return pSArgs;
    }

    @Override
    public QueryArguments getInsertPSArgs(RLog rLog) throws Throwable {
        PSArgs pSArgs = new PSArgs();
        pSArgs.addLongArg(this.instanceID);
        pSArgs.addLongArg(Long.valueOf(this.OID.get()));
        pSArgs.addIntArg(rLog.getLogID());
        pSArgs.addIntArg(rLog.getLogIndex());
        pSArgs.addIntArg(Integer.valueOf(rLog.getInlineNodeID()));
        pSArgs.addIntArg(rLog.getNodeID());
        pSArgs.addLongArg(rLog.getWorkitemID());
        pSArgs.addStringArg(rLog.getWorkitemName());
        pSArgs.addIntArg(rLog.getWorkitemState());
        pSArgs.addTimestampArg(rLog.getCreateTime());
        pSArgs.addTimestampArg(rLog.getFinishTime());
        pSArgs.addLongArg(rLog.getOperatorID());
        pSArgs.addIntArg(Integer.valueOf(rLog.getAuditResult()));
        pSArgs.addStringArg(rLog.getUserInfo());
        pSArgs.addStringArg(rLog.getResultInfo());
        pSArgs.addStringArg(rLog.getLaunchInfo());
        pSArgs.addIntArg(rLog.getTransactionID());
        pSArgs.addIntArg(rLog.getAssistTransactionID());
        pSArgs.addLongArg(rLog.getParentWorkitemID());
        return pSArgs;
    }

    public RLog copyDataFromWorkitem(RWorkitem rWorkitem, int n2, int n3) {
        RLog rLog = new RLog(this.instanceID);
        rLog.setLogID(n2);
        rLog.setInlineNodeID(rWorkitem.getInlineNodeID());
        rLog.setCreateTime(rWorkitem.getCreateTime());
        rLog.setLogIndex(n3);
        rLog.setNodeID(rWorkitem.getNodeID());
        rLog.setWorkitemID(rWorkitem.getWorkItemID());
        rLog.setWorkitemName(rWorkitem.getWorkItemName());
        if (rWorkitem.getInlineNodeID() > 0) {
            rLog.setParentWorkitemID(rWorkitem.getPartentWorkitemID());
        }
        this.copyData(rLog, rWorkitem);
        this.addRow(rLog);
        return rLog;
    }

    public void syncDataFromWorkitem(RWorkitem rWorkitem, IDBManager object) throws Throwable {
        this.load((IDBManager)object);
        for (RLog rLog : this.rowList) {
            if (rWorkitem.getLogID() <= 0) {
                if (!rLog.getWorkitemID().equals(rWorkitem.getWorkItemID())) continue;
                this.copyData(rLog, rWorkitem);
                return;
            }
            if (!rLog.getWorkitemID().equals(rWorkitem.getWorkItemID()) || rLog.getLogID().intValue() != rWorkitem.getLogID()) continue;
            this.copyData(rLog, rWorkitem);
            return;
        }
    }

    public void deleteData(long l2, IDBManager object) throws Throwable {
        this.load((IDBManager)object);
        for (RLog rLog : this.rowList) {
            if (rLog.getWorkitemID() != l2) continue;
            rLog.setDeleted();
            return;
        }
    }

    private void copyData(RLog rLog, RWorkitem rWorkitem) {
        rLog.setAuditResult(rWorkitem.getAuditResult());
        rLog.setFinishTime(rWorkitem.getFinishTime());
        rLog.setLaunchInfo(rWorkitem.getLaunchInfo());
        rLog.setResultInfo(rWorkitem.getResultInfo());
        rLog.setOperatorID(rWorkitem.getOperatorID());
        rLog.setUserInfo(rWorkitem.getUserInfo());
        rLog.setWorkitemState(rWorkitem.getWorkitemState());
    }

    public void changeLogIndex(Long number, RLog rLog, IDBManager iDBManager) throws Throwable {
        this.load(iDBManager);
        rLog.setLogIndex(-1);
        int n2 = -1;
        for (RLog rLog2 : this.rowList) {
            if (!rLog2.getWorkitemID().equals(number) || rLog2.getLogIndex() == -1) continue;
            n2 = rLog2.getLogIndex();
            break;
        }
        if (n2 < 0) {
            return;
        }
        for (RLog rLog2 : this.rowList) {
            number = rLog2.getLogIndex();
            if (rLog2.isDeleted() || (Integer)number < n2) continue;
            rLog2.setLogIndex((Integer)number + 1);
        }
        rLog.setLogIndex(n2);
    }

    public RLog getLastLog(int n2, int n3, IDBManager iDBManager) throws Throwable {
        this.load(iDBManager);
        int n4 = -1;
        RLog rLog = null;
        for (RLog rLog2 : this.rowList) {
            if (rLog2.getNodeID() != n3 || rLog2.getInlineNodeID() != n2 || rLog2.getWorkitemState() != 2 || rLog2.getLogIndex() <= n4) continue;
            n4 = rLog2.getLogIndex();
            rLog = rLog2;
        }
        return rLog;
    }

    public RLog getLogByWID(long l2, IDBManager object) throws Throwable {
        this.load((IDBManager)object);
        object = null;
        for (RLog rLog : this.rowList) {
            if (rLog.getWorkitemID() != l2) continue;
            object = rLog;
            break;
        }
        return object;
    }

    public List<RLog> getAllLogForSameWID(long l2, IDBManager object) throws Throwable {
        this.load((IDBManager)object);
        object = new ArrayList();
        for (RLog rLog : this.rowList) {
            if (rLog.getWorkitemID() != l2) continue;
            ((ArrayList)object).add(rLog);
        }
        return object;
    }

    @Override
    public RLog createEmptyRow() {
        return new RLog(this.instanceID);
    }
}

