package com.bokesoft.yigo.bpm.monitor;
/**
 * 日志数据实体类
 * @author wbh
 *
 */

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.json.JSONObject;

import com.bokesoft.yes.bpm.monitor.MonitorConstants;
import com.bokesoft.yes.tools.json.JSONUtil;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.json.JSONSerializable;

public class LogData implements JSONSerializable {
	
	private Map<String, Object> dataMap = new HashMap<String,Object>();
	/**
	 * 构造函数
	 */
	public LogData() {
		// TODO Auto-generated constructor stub
	}
	/**
	 * 构造函数，默认记录当前操作员、流程标识、实例ID以及操作时间数据
	 * @param context 上下文
	 * @param processKey 流程标识
	 */
	public LogData(BPMContext context, String processKey) {
		put(MonitorConstants.OPERATOR_ID, context.getCurUserID());
		put(MonitorConstants.PROCESS_KEY, processKey);
		put(MonitorConstants.INSTANCE_ID, context.getActiveBPMInstance().getInstanceData().getInstanceID());
		try {
			put(MonitorConstants.OPERATION_TIME, context.getDBManager().getCurTime());
		} catch (Throwable e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * 添加日志数据
	 * @param key
	 * @param value
	 */
	public void put(String key, Object value) {
		dataMap.put(key, value);
	}
	/**
	 * 清空日志数据
	 */
	public void clear() {
		if (dataMap != null && dataMap.size() > 0) {
			dataMap.clear();
		}
	}
	
	@Override
	public JSONObject toJSON() throws Throwable {
		JSONObject obj = null;
		if (dataMap != null && !dataMap.isEmpty()) {
			obj = new JSONObject(dataMap);
		}
		return obj;
	}
	@Override
	public void fromJSON(JSONObject jsonObj) throws Throwable {
		clear();
		if (jsonObj != null) {
			dataMap = JSONUtil.toMap(jsonObj.toString());
		}
	}
}
