package com.bokesoft.yigo.bpm.analysis;

import com.bokesoft.yes.bpm.analysis.AnalyseInstanceDuration;
import com.bokesoft.yes.bpm.analysis.AnalyseWorkitemDuration;

/**
 * 默认分析模式的工厂类
 * 
 * @author guowj
 *
 */
public class AnalysisDefaultModeFactory {

	public static final IAnalysisMode getAnalysisDefaultMode(String analysisType) {
		int type = DefaultAnalysisMode.parse(analysisType);
		switch (type) {
		case DefaultAnalysisMode.Default_InstanceDuration:
			return new AnalyseInstanceDuration();
		case DefaultAnalysisMode.Default_WorkitemDuration:
			return new AnalyseWorkitemDuration();
		}
		return null;
	}
}
