package com.bokesoft.yigo.bpm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.util.Date;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yigo.common.def.SystemDBField;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessDeployInfo;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessDeployInfoCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;

/**
 * 部署数据库流程
 * 
 * @author guowj
 *
 */
public class DeployDBProcess {
	
	public final static int ALREADY_DEPLOY = 1;
	public final static int UNDEPLOY = 0;

	private MetaProcess metaProcess = null;
	
	public DeployDBProcess() {
		// TODO Auto-generated constructor stub
	}
	
	public DeployDBProcess(MetaProcess metaProcess) {
		this.metaProcess = metaProcess;
	}
	
	public void deploy(DefaultContext context) throws Throwable {
		String processKey = metaProcess.getKey();
		int version = metaProcess.getVersion();
		IMetaFactory factory = context.getVE().getMetaFactory();
		if(factory.getMetaBPM() == null){
			return;
		}
		MetaProcessDeployInfoCollection metaProcessDeployInfoCollection = factory.getMetaBPM().getMetaBPMDeployInfoCollection();
		if(metaProcessDeployInfoCollection.containsKey(processKey)){
			if(metaProcessDeployInfoCollection.get(processKey).getVersion() == version){
				throw BPMError.getBPMError(context.getEnv(), BPMError.REPEAT_PROCESS_DEPLOY, processKey, version);
			}
		}
		
		// 只支持部署数据库中的流程
		checkDBProcess(context, processKey, version);
		
		// 部署标记持久化
		signAlreadyDeploy(context, processKey, version);
		
		// 更新流程的部署信息
		MetaProcessDeployInfo deployInfo = new MetaProcessDeployInfo();
		deployInfo.setKey(processKey);
		deployInfo.setVersion(version);
		deployInfo.setInitDate(DateFormat.getDateTimeInstance().format(new Date()));
		factory.getMetaBPM().getMetaBPMDeployInfoCollection().add(deployInfo);
	}
	
	private void checkDBProcess(DefaultContext context, String processKey, int version) throws Throwable{
		IDBManager DBManager = context.getDBManager();
		String sql = "select * from " 
				+ DBManager.keyWordEscape(SystemDBField.BPM_PROCESS) 
				+ " where "
				+ DBManager.keyWordEscape(SystemDBField.PROCESSKEY) + "=? and "
				+ DBManager.keyWordEscape(SystemDBField.WF_VERID) + "=?";
		PreparedStatement ps = null;
		ResultSet rs = null;
		try {
			ps = DBManager.preparedQueryStatement(sql);
			PSArgs args = new PSArgs();
			args.addStringArg(processKey);
			args.addIntArg(version);
			rs = DBManager.executeQuery(ps, sql, args);
			if(!rs.next()){
				throw BPMError.getBPMError(context.getEnv(), BPMError.NO_TARGET_PROCESS_OF_DEPLOY);
			}
		
		} finally {
			if (ps != null)
				ps.close();
			if (rs != null)
				rs.close();
		}
	}
	
	private void signAlreadyDeploy(DefaultContext context, String processKey, int version) throws Throwable{
		IDBManager DBManager = context.getDBManager();
		String sql = "select "
				+ DBManager.keyWordEscape(SystemDBField.ALREADYDEPLOY) + ","
				+ DBManager.keyWordEscape(SystemDBField.WF_VERID) 
				+ " from " 
				+ DBManager.keyWordEscape(SystemDBField.BPM_PROCESS) 
				+ " where "
				+ DBManager.keyWordEscape(SystemDBField.PROCESSKEY) + "=?";
		PreparedStatement ps = null;
		ResultSet rs = null;
		try {
			ps = DBManager.preparedQueryStatement(sql);
			PSArgs args = new PSArgs();
			args.addStringArg(processKey);
			rs = DBManager.executeQuery(ps, sql, args);
			while (rs.next()) {
				int alreadyDeploy = rs.getInt(1);
				int verID = rs.getInt(2);
				if(version == verID){
					if(alreadyDeploy != ALREADY_DEPLOY){
						updateDeploy(context, processKey, version, ALREADY_DEPLOY);
					}
				}else{
					if(alreadyDeploy == ALREADY_DEPLOY){
						updateDeploy(context, processKey, verID, UNDEPLOY);
					}
				}
			}
		
		} finally {
			if (ps != null)
				ps.close();
			if (rs != null)
				rs.close();
		}
	}
	
	private void updateDeploy(DefaultContext context, String processKey, int version, int isDeploy) throws Throwable{
		IDBManager DBManager = context.getDBManager();
		String deploySql = "update " 
				+ DBManager.keyWordEscape(SystemDBField.BPM_PROCESS) 
				+ " set "
				+ DBManager.keyWordEscape(SystemDBField.ALREADYDEPLOY) + "=?"
				+ " where "
				+ DBManager.keyWordEscape(SystemDBField.PROCESSKEY) + "=? and "
				+ DBManager.keyWordEscape(SystemDBField.WF_VERID) + "=?";
		PreparedStatement ps = null;
		try {
			ps = DBManager.preparedUpdateStatement(deploySql);
			PSArgs args = new PSArgs();
			args.addIntArg(isDeploy);
			args.addStringArg(processKey);
			args.addIntArg(version);
			DBManager.executeUpdate(ps, deploySql, args);
		
		} finally {
			if (ps != null)
				ps.close();
		}
	}
	
	public void setProcess(MetaProcess metaProcess){
		this.metaProcess = metaProcess;
	}
	
	public MetaProcess getProcess(){
		return metaProcess;
	}
	
}
