/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.workitem;

import com.bokesoft.yes.bpm.engine.common.BPMUtil;
import com.bokesoft.yes.bpm.engine.data.InstanceData;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.engine.util.ProcessUtil;
import com.bokesoft.yes.bpm.workitem.TransitData;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.bpm.workitem.data.RWorkitem;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.document.util.SystemTopicUtil;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class WorkitemUtil {
    public static Workitem loadWorkitem(DefaultContext defaultContext, Long l2) throws Throwable {
        return WorkitemUtil.loadWorkitem(defaultContext.getDBManager(), l2);
    }

    public static List<Workitem> getWorkitemsByInstanceID(IDBManager object, Long l2) throws Throwable {
        String string = "select b." + object.keyWordEscape("WorkitemID") + ",b." + object.keyWordEscape("InlineNodeID") + ",b." + object.keyWordEscape("NodeID") + " from " + object.keyWordEscape("BPM_WorkitemInfo") + " b left join " + object.keyWordEscape("WF_Workitem") + " w on b." + object.keyWordEscape("WorkitemID") + " = w." + object.keyWordEscape("WorkitemID") + " where " + object.keyWordEscape("InstanceID") + " = ? and " + object.keyWordEscape("AuditResult") + " = ?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<Workitem> arrayList = new ArrayList<Workitem>();
        try {
            preparedStatement = object.preparedQueryStatement(string);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addLongArg(l2);
            pSArgs.addIntArg(Integer.valueOf(-1));
            resultSet = object.executeQuery(preparedStatement, string, (QueryArguments)pSArgs);
            while (resultSet.next()) {
                object = new Workitem();
                ((Workitem)object).setWorkItemID(resultSet.getLong(1));
                ((Workitem)object).setInlineNodeID(resultSet.getInt(2));
                ((Workitem)object).setNodeID(resultSet.getInt(3));
                arrayList.add((Workitem)object);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return arrayList;
    }

    public static Workitem loadWorkitem(IDBManager object, Long l2) throws Throwable {
        Object object2;
        String string = "select " + object.keyWordEscape("InstanceID") + "," + object.keyWordEscape("InlineNodeID") + "," + object.keyWordEscape("NodeID") + "," + object.keyWordEscape("TransitTo") + "," + object.keyWordEscape("CountID") + "," + object.keyWordEscape("OID") + "," + object.keyWordEscape("InlinePara") + " from " + object.keyWordEscape("BPM_WorkitemInfo") + " where " + object.keyWordEscape("WorkitemID") + "=?";
        Object object3 = null;
        AutoCloseable autoCloseable = null;
        Workitem workitem = null;
        try {
            object3 = object.preparedQueryStatement(string);
            object2 = new PSArgs();
            object2.addLongArg(l2);
            autoCloseable = object.executeQuery((PreparedStatement)object3, string, (QueryArguments)object2);
            if (autoCloseable.next()) {
                workitem = new Workitem();
                workitem.setWorkItemID(l2);
                workitem.setInstanceID(autoCloseable.getLong(1));
                workitem.setInlineNodeID(autoCloseable.getInt(2));
                workitem.setNodeID(autoCloseable.getInt(3));
                workitem.setCountID(autoCloseable.getInt(5));
                workitem.setOID(autoCloseable.getLong(6));
                workitem.setInlinePara(autoCloseable.getString(7));
            }
        }
        finally {
            if (autoCloseable != null) {
                autoCloseable.close();
            }
            if (object3 != null) {
                object3.close();
            }
        }
        string = "select " + object.keyWordEscape("OperatorID") + " from " + object.keyWordEscape("WF_Participator") + " where " + object.keyWordEscape("WorkitemID") + "=? and " + object.keyWordEscape("Visible") + "=?";
        object2 = null;
        ResultSet resultSet = null;
        object3 = new HashSet();
        try {
            object2 = object.preparedQueryStatement(string);
            autoCloseable = new PSArgs();
            autoCloseable.addLongArg(l2);
            autoCloseable.addIntArg(1);
            resultSet = object.executeQuery((PreparedStatement)object2, string, (QueryArguments)autoCloseable);
            while (resultSet.next()) {
                ((HashSet)object3).add(resultSet.getLong(1));
            }
            if (workitem != null) {
                workitem.setParticipatorList((HashSet<Long>)object3);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (object2 != null) {
                object2.close();
            }
        }
        string = "select " + object.keyWordEscape("transitToWorkitem") + "," + object.keyWordEscape("NodeID") + " from " + object.keyWordEscape("BPM_TransitTo") + " where " + object.keyWordEscape("WorkitemID") + "=?";
        autoCloseable = null;
        object3 = null;
        try {
            autoCloseable = object.preparedQueryStatement(string);
            object2 = new PSArgs();
            object2.addLongArg(l2);
            object3 = object.executeQuery((PreparedStatement)autoCloseable, string, (QueryArguments)object2);
            if (workitem != null) {
                while (object3.next()) {
                    object = new TransitData(object3.getInt(2), object3.getLong(1));
                    workitem.addTransit((TransitData)object);
                }
            }
        }
        finally {
            if (object3 != null) {
                object3.close();
            }
            if (autoCloseable != null) {
                autoCloseable.close();
            }
        }
        return workitem;
    }

    public static void unlockWorkitem(BPMContext bPMContext, int n2, Long l2, MetaProcess object) throws Throwable {
        Object object2;
        new ArrayList();
        object = ProcessUtil.getSubsequences(bPMContext, n2, (MetaProcess)object);
        if (object == null || object.size() == 0) {
            return;
        }
        CharSequence charSequence = new StringBuffer();
        IDBManager iDBManager = object.iterator();
        while (iDBManager.hasNext()) {
            ((Integer)iDBManager.next()).intValue();
            charSequence.append(" ?,");
        }
        if (charSequence.length() > 0) {
            StringBuffer stringBuffer = charSequence;
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        iDBManager = bPMContext.getDBManager();
        charSequence = "select " + iDBManager.keyWordEscape("WorkitemID") + " from " + iDBManager.keyWordEscape("BPM_WorkitemInfo") + " where " + iDBManager.keyWordEscape("InstanceID") + "=? and " + iDBManager.keyWordEscape("NodeID") + " in (" + charSequence.toString() + ") and " + iDBManager.keyWordEscape("NodeID") + " !=?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try {
            preparedStatement = iDBManager.preparedQueryStatement((String)charSequence);
            object2 = new PSArgs();
            object2.addLongArg(l2);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                object2.addIntArg(Integer.valueOf(n3));
            }
            object2.addIntArg(Integer.valueOf(n2));
            resultSet = iDBManager.executeQuery(preparedStatement, (String)charSequence, (QueryArguments)object2);
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(1));
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (arrayList.size() == 0) {
            return;
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            long l3 = (Long)object2.next();
            RWorkitem rWorkitem = bPMContext.getActiveBPMInstance().getInstanceData().getWorkitemData().getWorkitemData(bPMContext, l3);
            if (rWorkitem.getWorkitemState() != 3) continue;
            rWorkitem.setWorkitemState(1);
        }
    }

    public static void lockWorkitem(BPMContext bPMContext, int n2, Long l2, MetaProcess metaProcess) throws Throwable {
        WorkitemUtil.lockWorkitemState(bPMContext, n2, l2, metaProcess, 3);
    }

    public static void lockWorkitemState(BPMContext bPMContext, int n2, Long object, MetaProcess metaProcess, int n3) throws Throwable {
        TreeSet<Long> treeSet = WorkitemUtil.getSubsequenceWorkitems(bPMContext, n2, object, metaProcess, false);
        if (treeSet.isEmpty()) {
            return;
        }
        treeSet = treeSet.iterator();
        while (treeSet.hasNext()) {
            long l2 = (Long)treeSet.next();
            object = bPMContext.getActiveBPMInstance().getInstanceData().getWorkitemData().getWorkitemData(bPMContext, l2);
            if (((RWorkitem)((Object)object)).getWorkitemState() == 2) continue;
            ((RWorkitem)((Object)object)).setWorkitemState(n3);
        }
    }

    public static TreeSet<Long> getSubsequenceWorkitems(BPMContext object, int n2, Long l2, MetaProcess object2, boolean bl) throws Throwable {
        TreeSet<Long> treeSet = new TreeSet<Long>();
        new ArrayList();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Object object3 = ProcessUtil.getSubsequences((BPMContext)((Object)object), n2, (MetaProcess)object2);
        if (object3 == null || object3.size() == 0) {
            return treeSet;
        }
        Comparable<StringBuffer> comparable = new StringBuffer();
        IDBManager iDBManager = object3.iterator();
        while (iDBManager.hasNext()) {
            int n3 = iDBManager.next();
            ((StringBuffer)comparable).append(" ?,");
            if (object2.getNodeByID(n3).getNodeType() != 12) continue;
            arrayList.add(n3);
        }
        if (((StringBuffer)comparable).length() > 0) {
            StringBuffer stringBuffer = comparable;
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        iDBManager = ((BPMContext)((Object)object)).getDBManager();
        String string = "select " + iDBManager.keyWordEscape("WorkitemID") + " from " + iDBManager.keyWordEscape("BPM_WorkitemInfo") + " where " + iDBManager.keyWordEscape("InstanceID") + "=? and " + iDBManager.keyWordEscape("NodeID") + " in (" + ((StringBuffer)comparable).toString() + ") and " + iDBManager.keyWordEscape("NodeID") + " !=?";
        PreparedStatement preparedStatement = null;
        object = null;
        try {
            preparedStatement = iDBManager.preparedQueryStatement(string);
            object2 = new PSArgs();
            object2.addLongArg(l2);
            object3 = object3.iterator();
            while (object3.hasNext()) {
                comparable = (Integer)object3.next();
                object2.addIntArg((Integer)comparable);
            }
            object2.addIntArg(Integer.valueOf(n2));
            object = iDBManager.executeQuery(preparedStatement, string, (QueryArguments)object2);
            while (object.next()) {
                treeSet.add(object.getLong(1));
            }
        }
        finally {
            if (object != null) {
                object.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (arrayList.size() > 0 && bl) {
            comparable = new StringBuffer();
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                int n4 = (Integer)object2.next();
                ((StringBuffer)comparable).append(n4);
                ((StringBuffer)comparable).append(",");
            }
            if (((StringBuffer)comparable).length() > 0) {
                Comparable<StringBuffer> comparable2 = comparable;
                ((StringBuffer)comparable2).deleteCharAt(((StringBuffer)comparable2).length() - 1);
            }
            string = "select " + iDBManager.keyWordEscape("WorkitemID") + " from " + iDBManager.keyWordEscape("BPM_WorkitemInfo") + " where " + iDBManager.keyWordEscape("InstanceID") + "=? and " + iDBManager.keyWordEscape("InlineNodeID") + " in (?)";
            try {
                preparedStatement = iDBManager.preparedQueryStatement(string);
                object2 = new PSArgs();
                object2.addLongArg(l2);
                object2.addStringArg(((StringBuffer)comparable).toString());
                object = iDBManager.executeQuery(preparedStatement, string, (QueryArguments)object2);
                while (object.next()) {
                    treeSet.add(object.getLong(1));
                }
            }
            finally {
                if (object != null) {
                    object.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        return treeSet;
    }

    public static void changeAllWorkitemState(BPMContext bPMContext, Long object, int n2) throws Throwable {
        object = bPMContext.getActiveBPMInstance().getInstanceData();
        for (long l2 : ((InstanceData)object).getWorkitemInfo().getAllIDSet(bPMContext.getDBManager())) {
            RWorkitem rWorkitem = ((InstanceData)object).getWorkitemData().getWorkitemData(bPMContext, l2);
            if (rWorkitem == null || rWorkitem.getWorkitemState() == 2) continue;
            rWorkitem.setWorkitemState(n2);
        }
    }

    public static void removeWorkitems(BPMContext bPMContext, Integer object, Long l2, MetaProcess object2) throws Throwable {
        Object object3;
        Object object4;
        Object object5;
        new ArrayList();
        object2 = ProcessUtil.getSubsequences(bPMContext, object, (MetaProcess)object2);
        StringBuffer stringBuffer = new StringBuffer();
        if (object2 == null || object2.size() == 0) {
            return;
        }
        IDBManager iDBManager = object2.iterator();
        while (iDBManager.hasNext()) {
            ((Integer)iDBManager.next()).intValue();
            stringBuffer.append(" ?,");
        }
        if (stringBuffer.length() > 0) {
            StringBuffer stringBuffer2 = stringBuffer;
            stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
        }
        iDBManager = bPMContext.getDBManager();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        String string = "select " + iDBManager.keyWordEscape("WorkitemID") + " from " + iDBManager.keyWordEscape("BPM_WorkitemInfo") + " where " + iDBManager.keyWordEscape("InstanceID") + "=? and " + iDBManager.keyWordEscape("NodeID") + " in (" + stringBuffer.toString() + ") and " + iDBManager.keyWordEscape("NodeID") + " !=?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = iDBManager.preparedQueryStatement(string);
            object5 = new PSArgs();
            object5.addLongArg(l2);
            object4 = object2.iterator();
            while (object4.hasNext()) {
                object3 = (Integer)object4.next();
                object5.addIntArg((Integer)object3);
            }
            object5.addIntArg(object);
            resultSet = iDBManager.executeQuery(preparedStatement, string, (QueryArguments)object5);
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(1));
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (arrayList.size() == 0) {
            return;
        }
        object5 = "delete from " + iDBManager.keyWordEscape("BPM_StepInfo") + " where " + iDBManager.keyWordEscape("InstanceID") + "=? and " + iDBManager.keyWordEscape("TargetNodeID") + " in (" + stringBuffer.toString() + ")";
        object4 = null;
        try {
            object4 = iDBManager.preparedUpdateStatement((String)object5);
            object3 = new PSArgs();
            object3.addLongArg(l2);
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Integer n2 = (Integer)iterator.next();
                object3.addIntArg(n2);
            }
            iDBManager.executeUpdate((PreparedStatement)object4, (String)object5, (QueryArguments)object3);
        }
        finally {
            if (object4 != null) {
                object4.close();
            }
        }
        object3 = arrayList.iterator();
        while (object3.hasNext()) {
            long l3 = (Long)object3.next();
            object = bPMContext.getActiveBPMInstance().getInstanceData().getWorkitemData().getWorkitemData(bPMContext, l3);
            if (((RWorkitem)((Object)object)).getWorkitemState() != 3) continue;
            object.setDeleted();
            bPMContext.getActiveBPMInstance().getInstanceData().getWorkitemInfo().getWorkitemInfo(l3, bPMContext.getDBManager()).setDeleted();
            bPMContext.getActiveBPMInstance().getInstanceData().getWorkitemData().deleteParticipatorData(l3);
        }
    }

    public static boolean existUnFinishedWorkitem(BPMContext bPMContext, Integer object, Long l2, MetaProcess object2) throws Throwable {
        Object object3;
        new ArrayList();
        object = ProcessUtil.getPresequences(bPMContext, (Integer)object, (MetaProcess)object2);
        if (object == null) {
            return false;
        }
        object2 = new StringBuffer();
        IDBManager iDBManager = object.iterator();
        while (iDBManager.hasNext()) {
            ((Integer)iDBManager.next()).intValue();
            ((StringBuffer)object2).append(" ?,");
        }
        if (((StringBuffer)object2).length() > 0) {
            Object object4 = object2;
            ((StringBuffer)object4).deleteCharAt(((StringBuffer)object4).length() - 1);
        }
        iDBManager = bPMContext.getDBManager();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        object2 = "select " + iDBManager.keyWordEscape("WorkitemID") + " from " + iDBManager.keyWordEscape("BPM_WorkitemInfo") + " where " + iDBManager.keyWordEscape("InstanceID") + "=? and " + iDBManager.keyWordEscape("NodeID") + " in (" + ((StringBuffer)object2).toString() + ")";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = iDBManager.preparedQueryStatement((String)object2);
            object3 = new PSArgs();
            object3.addLongArg(l2);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Integer n2 = (Integer)iterator.next();
                object3.addIntArg(n2);
            }
            resultSet = iDBManager.executeQuery(preparedStatement, (String)object2, (QueryArguments)object3);
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(1));
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (arrayList.size() == 0) {
            return false;
        }
        object3 = arrayList.iterator();
        while (object3.hasNext()) {
            long l3 = (Long)object3.next();
            if (bPMContext.getActiveBPMInstance().getInstanceData().getWorkitemData().getWorkitemData(bPMContext, l3).getWorkitemState() == 2) continue;
            return true;
        }
        return false;
    }

    public static void updateCheckerField(BPMContext bPMContext) throws Throwable {
        DataTable dataTable;
        Document document = bPMContext.getDocument();
        if (document == null) {
            return;
        }
        MetaTable metaTable = document.getMetaDataObject().getMainTable();
        if (metaTable != null && (dataTable = document.get(metaTable.getKey())) != null) {
            MetaColumn metaColumn = metaTable.getCHECKER();
            if (metaColumn != null && SystemTopicUtil.check((DefaultContext)bPMContext, (String)metaColumn.getKey())) {
                dataTable.setLong(metaColumn.getKey(), bPMContext.getCurUserID());
                document.setModified();
            }
            if ((metaTable = metaTable.getCHECKERTIME()) != null && SystemTopicUtil.check((DefaultContext)bPMContext, (String)metaTable.getKey())) {
                dataTable.setDateTime(metaTable.getKey(), new Date(bPMContext.getDBManager().getCurTime()));
                document.setModified();
            }
        }
        bPMContext.setUpdateCheckerField(false);
    }

    public static void checkAndLock(BPMContext bPMContext, ExecNode execNode) throws Throwable {
        int n2 = execNode.getID();
        int n3 = execNode.getNodeModel().getLockWorkitem();
        BPMContext bPMContext2 = bPMContext;
        MetaProcess metaProcess = BPMUtil.getProcessByInstance(bPMContext2, bPMContext2.getActiveBPMInstance());
        if (metaProcess == null) {
            return;
        }
        block0 : switch (n3) {
            case 1: {
                n3 = 1;
                break;
            }
            case 0: {
                n3 = 0;
                break;
            }
            default: {
                switch (metaProcess.getLockWorkitem()) {
                    case 1: {
                        n3 = 1;
                        break block0;
                    }
                }
                n3 = 0;
            }
        }
        if (n3 != 0) {
            WorkitemUtil.lockWorkitem(bPMContext, n2, execNode.getVirtualInstance().getInstanceID(), metaProcess);
        }
    }
}

