/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.service.cmd;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.common.BPMUtil;
import com.bokesoft.yes.bpm.service.cmd.BPMServiceCmd;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.json.MetaProcessJsonUnserializer;
import com.bokesoft.yes.meta.persist.dom.bpm.MetaBPMLoad;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.FileUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.bpm.process.IJsonUnserializer;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.bpm.total.MetaBPM;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessDeployInfo;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class HotDeployProcessCmd
extends BPMServiceCmd {
    public static final String TAG = "HotDeployProcess";
    private String formKey = "";
    private String dataObjectKey = "";
    private String processKey = "";
    private Integer verID = -1;

    public IServiceCmd<BPMContext> newInstance() {
        return new HotDeployProcessCmd();
    }

    @Override
    public void dealArguments(BPMContext bPMContext, StringHashMap<Object> stringHashMap) throws Throwable {
        this.formKey = TypeConvertor.toString((Object)stringHashMap.get((Object)"formKey"));
        this.dataObjectKey = TypeConvertor.toString((Object)stringHashMap.get((Object)"dataObjectKey"));
        if (stringHashMap.get((Object)"processKey") != null) {
            this.processKey = TypeConvertor.toString((Object)stringHashMap.get((Object)"processKey"));
        }
        if (stringHashMap.get((Object)"verID") != null && TypeConvertor.toInteger((Object)stringHashMap.get((Object)"verID")) > 0) {
            this.verID = TypeConvertor.toInteger((Object)stringHashMap.get((Object)"verID"));
        }
    }

    @Override
    public Object doCmd(BPMContext bPMContext) throws Throwable {
        MetaBPM metaBPM = bPMContext.getVE().getMetaFactory().getMetaBPM();
        if (metaBPM == null) {
            return Boolean.FALSE;
        }
        ProcessDefinitionProfile processDefinitionProfile = null;
        String string = BPMUtil.getProcessVersionKeyByMetaKey(bPMContext, this.dataObjectKey, this.formKey, metaBPM);
        if (string != null && string.length() > 0) {
            processDefinitionProfile = (ProcessDefinitionProfile)metaBPM.getProfileMap().get(string);
        }
        if (processDefinitionProfile == null) {
            return Boolean.FALSE;
        }
        string = processDefinitionProfile.getResource();
        String string2 = "";
        if (processDefinitionProfile.getProject() != null) {
            string2 = processDefinitionProfile.getProject().getKey();
        }
        MetaBPM metaBPM2 = null;
        if (string2 != null && string2.length() > 0) {
            metaBPM2 = this.loadNewBPM(string2, bPMContext);
        }
        if ((string2 = this.getNewKey(bPMContext, string2, metaBPM2)) == null || string2.length() == 0) {
            return Boolean.FALSE;
        }
        String string3 = "";
        String string4 = string2.split("_V")[0];
        Integer n2 = TypeConvertor.toInteger((Object)string2.split("_V")[1]);
        if (processDefinitionProfile.getKey().equalsIgnoreCase(string4)) {
            if (n2 <= processDefinitionProfile.getVersion()) {
                if (n2.intValue() == processDefinitionProfile.getVersion()) {
                    return Boolean.FALSE;
                }
                throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)48, (Object[])new Object[0]);
            }
        } else {
            if (n2 == 1) {
                string2 = string4;
            }
            string3 = this.getValidProcessMapJson(bPMContext);
        }
        ProcessDefinitionProfile processDefinitionProfile2 = null;
        if (string != null && string.length() > 0) {
            string = FileUtil.replaceSeparatorChar((String)string);
            string = StringUtils.substringBeforeLast((String)string, (String)String.valueOf(File.separatorChar)) + File.separatorChar + string2 + ".xml";
            processDefinitionProfile2 = this.loadNewProcessDefinitionProfile(bPMContext, processDefinitionProfile, string);
        }
        if (processDefinitionProfile2 == null) {
            processDefinitionProfile2 = this.queryDBProcess(string4, n2, bPMContext);
        }
        if (processDefinitionProfile2 == null) {
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)50, (Object[])new Object[0]);
        }
        this.recordLastHotDeployInfo(bPMContext, processDefinitionProfile, string3);
        metaBPM.getProfileMap().put(string2, processDefinitionProfile2);
        this.updateMetaBPM(metaBPM, metaBPM2, string4, n2);
        return Boolean.TRUE;
    }

    private String getNewKey(BPMContext bPMContext, String string, MetaBPM metaBPM) throws Throwable {
        String string2 = "";
        if (this.processKey.length() > 0 && this.verID != -1) {
            string = BPMUtil.getMapInfoByMetaKey(bPMContext, this.dataObjectKey, this.formKey);
            if (string == null || !string.getProcessKey().equalsIgnoreCase(this.processKey)) {
                throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)52, (Object[])new Object[0]);
            }
            string2 = this.processKey + "_V" + this.verID;
        } else if (this.processKey.length() == 0 && this.verID == -1) {
            if (string == null || string.length() == 0) {
                throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)51, (Object[])new Object[0]);
            }
            if (metaBPM != null) {
                string2 = BPMUtil.getProcessVersionKeyByMetaKey(bPMContext, this.dataObjectKey, this.formKey, metaBPM);
            }
        } else {
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)51, (Object[])new Object[0]);
        }
        return string2;
    }

    private void recordLastHotDeployInfo(BPMContext object, ProcessDefinitionProfile processDefinitionProfile, String string) throws Throwable {
        ResultSet resultSet;
        block9: {
            Integer.valueOf(-1);
            IDBManager iDBManager = object.getDBManager();
            String string2 = "select " + iDBManager.keyWordEscape("HotDeployID") + " from " + iDBManager.keyWordEscape("BPM_HotDeploy") + " where " + iDBManager.keyWordEscape("FormKey") + " = ? and " + iDBManager.keyWordEscape("DataObjectKey") + " = ? order by " + iDBManager.keyWordEscape("HotDeployID") + " desc";
            PreparedStatement preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = iDBManager.preparedQueryStatement(string2);
                PSArgs pSArgs = new PSArgs();
                if (this.formKey == null || this.formKey.length() == 0) {
                    pSArgs.addStringArg("*");
                } else {
                    pSArgs.addStringArg(this.formKey);
                }
                pSArgs.addStringArg(this.dataObjectKey);
                resultSet = iDBManager.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
                object = resultSet.next() ? Integer.valueOf(resultSet.getInt(1) + 1) : Integer.valueOf(1);
                preparedStatement.close();
                string2 = "insert into " + iDBManager.keyWordEscape("BPM_HotDeploy") + " (" + iDBManager.keyWordEscape("FormKey") + ", " + iDBManager.keyWordEscape("HotDeployID") + ", " + iDBManager.keyWordEscape("DataObjectKey") + ", " + iDBManager.keyWordEscape("ProcessKey") + ", " + iDBManager.keyWordEscape("WFVerID") + ", " + iDBManager.keyWordEscape("ProcessMapInfo") + ") values (?,?,?,?,?,?) ";
                preparedStatement = iDBManager.preparedUpdateStatement(string2);
                pSArgs = new PSArgs();
                if (this.formKey == null || this.formKey.length() == 0) {
                    pSArgs.addStringArg("*");
                } else {
                    pSArgs.addStringArg(this.formKey);
                }
                pSArgs.addIntArg((Integer)object);
                pSArgs.addStringArg(this.dataObjectKey);
                pSArgs.addStringArg(processDefinitionProfile.getKey());
                pSArgs.addIntArg(Integer.valueOf(processDefinitionProfile.getVersion()));
                pSArgs.addStringArg(string);
                iDBManager.executeUpdate(preparedStatement, string2, (QueryArguments)pSArgs);
                if (preparedStatement == null) break block9;
            }
            catch (Throwable throwable) {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                throw throwable;
            }
            preparedStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
            return;
        }
    }

    private ProcessDefinitionProfile queryDBProcess(String string, Integer n2, BPMContext object) throws Throwable {
        String string2 = null;
        object = object.getDBManager();
        String string3 = "select " + object.keyWordEscape("Caption") + "," + object.keyWordEscape("Defination") + " from " + object.keyWordEscape("BPM_Process") + " where " + object.keyWordEscape("ProcessKey") + " = ? and " + object.keyWordEscape("WFVerID") + " = ?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = object.preparedQueryStatement(string3);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addStringArg(string);
            pSArgs.addIntArg(n2);
            resultSet = object.executeQuery(preparedStatement, string3, (QueryArguments)pSArgs);
            if (resultSet.next()) {
                object = resultSet.getString(1);
                string2 = resultSet.getString(2);
                string3 = null;
                if (string2 != null && string2.length() > 0) {
                    string3 = new JSONObject(string2);
                }
                string2 = new ProcessDefinitionProfile();
                string2.setKey(string);
                string2.setCaption((String)object);
                string2.setVersion(n2.intValue());
                string2.setDefinationJson((JSONObject)string3);
                string2.setJsonUnserializer((IJsonUnserializer)new MetaProcessJsonUnserializer());
                string2.setSourceType("DB");
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return string2;
    }

    private ProcessDefinitionProfile loadNewProcessDefinitionProfile(BPMContext object, ProcessDefinitionProfile processDefinitionProfile, String string) throws Throwable {
        ProcessDefinitionProfile processDefinitionProfile2 = null;
        if ((object = ((BPMContext)((Object)object)).getVE().getMetaFactory().readProfile(string)) == null) {
            return null;
        }
        String string2 = object.optString("TagName");
        if ("Process".equals(string2)) {
            processDefinitionProfile2 = new ProcessDefinitionProfile();
            string2 = object.optString("Key");
            String string3 = object.optString("Caption");
            object = (object = object.optString("Version")) == null || ((String)object).length() == 0 ? 1 : Integer.parseInt((String)object);
            processDefinitionProfile2.setKey(string2);
            processDefinitionProfile2.setCaption(string3);
            processDefinitionProfile2.setVersion(((Integer)object).intValue());
            processDefinitionProfile2.setResource(string);
            processDefinitionProfile2.setProject(processDefinitionProfile.getProject());
            processDefinitionProfile2.setSourceType("Directory");
        }
        return processDefinitionProfile2;
    }

    private void updateMetaBPM(MetaBPM metaBPM, MetaBPM metaBPM2, String string, Integer n2) {
        MetaProcessDeployInfo metaProcessDeployInfo = new MetaProcessDeployInfo();
        metaProcessDeployInfo.setKey(string);
        metaProcessDeployInfo.setVersion(n2);
        metaProcessDeployInfo.setInitDate(DateFormat.getDateTimeInstance().format(new Date()));
        metaBPM.getMetaBPMDeployInfoCollection().add((KeyPairMetaObject)metaProcessDeployInfo);
        if (metaBPM2 != null) {
            if (metaBPM2.getMetaProcessMapCollection().getFormMap().containsKey((Object)this.formKey)) {
                metaBPM.getMetaProcessMapCollection().getFormMap().put((Object)this.formKey, (Object)metaBPM2.getMetaProcessMapCollection().getFormMapInfo(this.formKey));
            }
            if (metaBPM2.getMetaProcessMapCollection().getDataObjectMap().containsKey((Object)this.dataObjectKey)) {
                metaBPM.getMetaProcessMapCollection().getDataObjectMap().put((Object)this.dataObjectKey, (Object)metaBPM2.getMetaProcessMapCollection().getDataobjectMapInfo(this.dataObjectKey));
            }
        }
    }

    private String getValidProcessMapJson(BPMContext bPMContext) throws Throwable {
        String string = "";
        if ((bPMContext = BPMUtil.getMapInfoByMetaKey(bPMContext, this.dataObjectKey, this.formKey)) != null) {
            string = bPMContext.toJSON().toString();
        }
        return string;
    }

    private MetaBPM loadNewBPM(String string, BPMContext bPMContext) throws Throwable {
        MetaBPMLoad metaBPMLoad = new MetaBPMLoad(1);
        string = string + File.separatorChar + "BPM.xml";
        metaBPMLoad.load(bPMContext.getVE().getMetaFactory().loadResource(string));
        return (MetaBPM)metaBPMLoad.getRootMetaObject();
    }

    @Override
    public String getCmd() {
        return TAG;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String string) {
        this.formKey = string;
    }

    public String getDataObjectKey() {
        return this.dataObjectKey;
    }

    public void setDataObjectKey(String string) {
        this.dataObjectKey = string;
    }

    public void setProcessKey(String string) {
        this.processKey = string;
    }

    public String getProcessKey() {
        return this.processKey;
    }

    public void setVerID(Integer n2) {
        this.verID = n2;
    }

    public Integer getVerID() {
        return this.verID;
    }
}

