package com.bokesoft.yigo.bpm.common;

import java.util.HashSet;
import java.util.Set;

import com.bokesoft.yes.bpm.engine.common.BPMGrantID;
import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.engine.util.SaveableInstanceContainer;
import com.bokesoft.yes.bpm.extdata.DataInputOutputHandler;
import com.bokesoft.yes.bpm.meta.transform.BPMKeys;
import com.bokesoft.yes.bpm.meta.transform.BPMOperationType;
import com.bokesoft.yes.bpm.workitem.TransitData;
import com.bokesoft.yes.bpm.workitem.Workitem;
import com.bokesoft.yes.gop.bpm.IExecutionContext;
import com.bokesoft.yes.gop.bpm.IExecutionNode;
import com.bokesoft.yes.mid.base.ContextContainer;
import com.bokesoft.yes.mid.base.MidVE;
import com.bokesoft.yes.mid.service.MidProcessFlowHandler;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.document.LoadFormData;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.env.Env;

/**
 * 中间层上下文
 * 
 * @author 刘翔翔
 * 
 */
public class BPMContext extends DefaultContext implements IExecutionContext{

	public static final Integer TYPE = 2;

	public static BPMContext getBPMContext(DefaultContext context, Long InstanceID) throws Throwable {
		ContextContainer cotextContainer = context.getContextContainer();
		BPMContext dc = (BPMContext) cotextContainer.getContext(InstanceID, TYPE);
		if (dc == null) {
			dc = new BPMContext(context);
			cotextContainer.putContext(InstanceID, TYPE, dc);
		}
		return dc;
	}

	public static BPMContext getBPMContext(BPMContext context, Long InstanceID) throws Throwable {
		ContextContainer cotextContainer = context.getContextContainer();
		BPMContext dc = (BPMContext) cotextContainer.getContext(InstanceID, TYPE);
		if (dc == null) {
			// 如果这个上下文已经用其它名字注册过，就重现创建一个
			if (cotextContainer.existContextByType(TYPE, context))
				dc = new BPMContext(context);
			else
				dc = context;
			cotextContainer.putContext(InstanceID, TYPE, dc);
		}
		return dc;
	}

	public static void setDoc(BPMContext context, String formKey, Long OID) throws Throwable {

		context.setFormKey(formKey);
		if (context.getDocument() == null || context.getDocument().getOID() != OID) {
			// 初始化上下文的元文件信息
			IMetaFactory metaFactory = context.getVE().getMetaFactory();
			MetaForm metaForm = metaFactory.getMetaForm(formKey);
			context.setDataObject(metaForm.getDataSource().getDataObject());
			Document doc = null;

			ContextContainer cotextContainer = context.getContextContainer();
			DefaultContext dc = (DefaultContext) cotextContainer.getContext(OID, DefaultContext.TYPE);
			if (dc != null && dc.getDocument() != null)
				doc = dc.getDocument();
			else {
				// 载入关联单据
				LoadFormData loadData = new LoadFormData(formKey, OID);
				cotextContainer.putContext(OID, DefaultContext.TYPE, context);
				context.setProcessFlowOnDBIOLoad(false);
				try {
					doc = loadData.load(context, null);
				} finally {
					context.setProcessFlowOnDBIOLoad(true);
				}
				MidProcessFlowHandler flowHandler = new MidProcessFlowHandler("LoadData", "Post");
				flowHandler.doProcess(context);
			}

			context.setDocument(doc);

		}

	}

	/** 当前正在被提交工作项 */
	private Workitem updateWorkitem = null;

	/** 当前创建的工作项ID */
	private Long newWorkitemID = -1l;

	/** 当前正在被处理的实例 */
	private BPMInstance activeBPMInstance = null;

	/** 当前令牌的编号 */
	private int activeTokenID = -1;

	/** 当前节点 */
	private ExecNode activeNode = null;
	
	/** 标记内联*/
	private ExecNode inlineNode = null;
	private boolean isInline = false;

	/** 实例数据 */
	private SaveableInstanceContainer instanceData = null;

	/** 动态驳回位置 */
	private String backSite = "";
	/** 任意跳转位置*/
	private int straightSite = -1;
	/** 直送位置*/
	private int transitTo = -1;
	/** 直送位置的工作项ID*/
	long backSiteWorkitemID = -1;
	/** 动态驳回位置的可选的操作员（会签节点） */
	long backSiteOpt=-1;
	
	/** 驳回后是否允许直送*/
	private boolean allowTransit = true;
	
	/** 管理员代替操作时的原操作员*/
	private long srcOperator = -1l;
	
	/** 当前流程实例操作类型*/
	private int operationType = BPMOperationType.OPT_COMMIT;
	/** 是否为撤销操作*/
	private boolean isRevoke = false;
	/** 撤销位置的工作项ID*/
	private long revokeWorkitemID = -1l;
	/** 当前参与者*/
	private Long activeParticipator = null;
	/** 跳转到内联流程的节点ID*/
	private int straightEmbedNodeID = -1;
	
	/** 流程直送信息*/
	private TransitData transitData;

	/** 是否需要更新系统字段*/
	private boolean updateCheckerField = true;
	
	/** 是否发起辅助任务*/
	private boolean isAssistanceTask = false;
	/** 是否为批量加签*/
	private boolean isBatchEndorse = false;
	
	private DataInputOutputHandler inputHandler = null;
	
	private DataInputOutputHandler outputHandler = null;
	
	public BPMContext(MidVE ve) throws Throwable {
		super(ve);
		instanceData = new SaveableInstanceContainer(this);
	}

	public BPMContext(DefaultContext context) throws Throwable {
		super(context);
		instanceData = new SaveableInstanceContainer(this);
		this.setHeadInfos(context.getHeadInfos());
	}

	/**
	 * @return 数据对象标识
	 */
	public String getDataObjectKey() {
		return this.document.getMetaDataObject().getKey();
	}

	/**
	 * @deprecated 不对二开开放，仅内部使用; 获取流程实例ID,请使用 {@link #getInstanceID()}
	 * @return 当前活动的流程实例
	 */
	public BPMInstance getActiveBPMInstance() {
		return activeBPMInstance;
	}

	/**
	 * @param activeBPMInstance 当前活动的流程实例
	 * @deprecated 不对二开开放，仅内部使用
	 */
	public void setActiveBPMInstance(BPMInstance activeBPMInstance) {
		this.activeBPMInstance = activeBPMInstance;
	}
	
	/**
	 * @return 获取当前活动实例的ID,若实例不存在，返回-1
	 */
	public long getInstanceID() {
		if (activeBPMInstance != null) {
			return activeBPMInstance.getInstanceID();
		}
		return -1l;
	}
	
	/**
	 * @return 当前活动实例对应流程的VersionID，若实例不存在，返回-1
	 */
	public int getVerID() {
		return activeBPMInstance == null ? -1 : activeBPMInstance.getInstanceData().getInstance().getData().getVerID(); 
	}
	/**
	 * 
	 * @return 当前活动实例对应的流程标识，若实例不存在，返回null
	 */
	public String getProcesskey() {
		return activeBPMInstance == null ? null : activeBPMInstance.getInstanceData().getInstance().getData().getProcessKey();
	}
	/***
	 * @return 当前活动实例的状态，若实例不存在，返回-1;
	 */
	public int getInstanceState() {
		return activeBPMInstance == null ? -1 : activeBPMInstance.getInstanceData().getInstance().getData().getInstanceState();
	}

	/**
	 * @return 获取当前活动tokenID
	 */
	public int getActiveTokenID() {
		return activeTokenID;
	}

	/**
	 * @param activeTokenID 设置当前活动tokenID
	 */
	public void setActiveTokenID(int activeTokenID) {
		this.activeTokenID = activeTokenID;
	}

	/**
	 * @return 当前活动节点ID,若当前活动节点为null,则返回-1
	 */
	public int getActiveNodeID() {
		return activeNode == null ? -1 : activeNode.getID();
	}

	/**
	 * @deprecated 不对二开开放，仅内部使用
	 * @return 当前活动节点
	 */
	public ExecNode getActiveNode() {
		return activeNode;
	}

	/**
	 * @deprecated 不对二开开放，仅内部使用
	 * @param activeNode 活动节点
	 */
	public void setActiveNode(ExecNode activeNode) {
		this.activeNode = activeNode;
	}
	
	/**
	 * @deprecated 不对二开开放，仅内部使用, 获取当前正在提交工作项ID，请使用{@link #getUpdateWorkitemID()} 
	 * @return 当前正在提交的工作项
	 */
	public Workitem getUpdateWorkitem() {
		return updateWorkitem;
	}
	/**
	 * @deprecated 不对二开开放，仅内部使用
	 * @param updateWorkitem 当前正在提交的工作项
	 */
	public void setUpdateWorkitem(Workitem updateWorkitem) {
		this.updateWorkitem = updateWorkitem;
	}
	/**
	 * 
	 * @return 获取当前正在提交工作项的ID,若当前正在提交的工作项为null,则返回-1
	 */
	public long getUpdateWorkitemID() {
		return updateWorkitem == null ? -1 : updateWorkitem.getWorkItemID();
	} 
	/**
	 * @return 获取当前新创建工作项的ID
	 */
	public Long getNewWorkitemID() {
		return newWorkitemID;
	}
	/**
	 * 设置当前新创建工作项的ID 
	 * @param newWorkitemID 工作项ID
	 */
	public void setNewWorkitemID(Long newWorkitemID) {
		this.newWorkitemID = newWorkitemID;
	}

	/**
	 * @deprecated 不对二开开放，仅内部使用
	 * @return 当前事务中所有实例数据的代理类
	 */
	public SaveableInstanceContainer getInstanceDataContainer() {
		return instanceData;
	}
	/**
	 * 生成全局唯一的工作项ID
	 * @return 工作项ID
	 * @throws Throwable
	 */
	public Long applyNewWorkitemID() throws Throwable {
		return BPMGrantID.applyID(this, BPMGrantID.WORKITEMID);
	}
	/**
	 * 生成全局唯一的流程实例ID
	 * @return 流程实例ID
	 * @throws Throwable
	 */
	public Long applyNewInstanceID() throws Throwable {
		return BPMGrantID.applyID(this, BPMGrantID.INSTANCEID);
	}
	/**
	 * 
	 * @return 当前环境下的操作员ID
	 */
	public Long getCurUserID() {
		return getVE().getEnv().getUserID();
	}
	/**
	 * 
	 * @return 驳回位置
	 */
	public String getBackSite() {
		return backSite;
	}
	/**
	 * 
	 * @param backSite 驳回位置
	 */
	public void setBackSite(String backSite) {
		this.backSite = backSite;
	}
	
	public void setStraightSite(int straightSite) {
		this.straightSite = straightSite;
	}
	
	public int getStraightSite() {
		return straightSite;
	}
	
	/**
	 * 
	 * @return 驳回后是否允许直送，默认值为true
	 */
	public boolean isAllowTransit() {
		return allowTransit;
	}
	/**
	 * @param allowTransit 驳回后是否允许直送
	 */
	public void setAllowTransit(boolean allowTransit) {
		this.allowTransit = allowTransit;
	}
	/**
	 * 获取直送位置，用于驳回操作中
	 * @return 直送位置
	 */
	public int getTransitTo() {
		return transitTo;
	}
	/**
	 * 
	 * @param transitTo 直送位置
	 */
	public void setTransitTo(int transitTo) {
		this.transitTo = transitTo;
	}
	/**
	 * 
	 * @return 当前操作的类型，{@link BPMOperationType}
	 */
	public int getOperationType() {
		return operationType;
	}
	/**
	 * 
	 * @param operationType 当前操作的类型,{@link BPMOperationType}
	 */
	public void setOperationType(int operationType) {
		this.operationType = operationType;
	}
	
	public boolean isRevoke() {
		return isRevoke;
	}
	
	public void setRevoke(boolean isRevoke) {
		this.isRevoke = isRevoke;
	}
	
	public void setInlineNode(ExecNode inlineNode){
		this.inlineNode = inlineNode;
	}
	
	public ExecNode getInlineNode(){
		return inlineNode;
	}
	
	public void setIsInline(boolean isInline){
		this.isInline = isInline;
	}
	
	public boolean isInline(){
		return isInline;
	}
	
	public int getStraightEmbedNodeID(){
		return straightEmbedNodeID;
	}
	
	public void setStraightEmbedNodeID(int straightEmbedNodeID){
		this.straightEmbedNodeID = straightEmbedNodeID;
	}
	
	public long getRevokeWorkitemID(){
		return revokeWorkitemID;
	}
	
	public void setRevokeWorkitemID(long revokeWorkitemID){
		this.revokeWorkitemID = revokeWorkitemID;
	}
	/**
	 * 
	 * @param updateCheckerField 是否需要更新系统字段
	 */
	public void setUpdateCheckerField(boolean updateCheckerField) {
		this.updateCheckerField = updateCheckerField;
	}
	/**
	 * 
	 * @return 是否需要更新系统字段，默认为true
	 */
	public boolean updateCheckerField(){
		return updateCheckerField;
	}
	/**
	 * 获取当前参与者，一般用于执行创建工作项事件
	 * @return 当前参与者
	 */
	public Long getActiveParticipator() {
		return activeParticipator;
	}
	/**
	 * 
	 * @param activeParticipator 当前参与者
	 */
	public void setActiveParticipator(Long activeParticipator) {
		this.activeParticipator = activeParticipator;
	}

	/**
	 * @return 直送位置的工作项ID
	 */
	public long getBackSiteWorkitemID() {
		return backSiteWorkitemID;
	}

	/**
	 * @param backSiteWorkitemID 直送位置的工作项ID
	 */
	public void setBackSiteWorkitemID(long backSiteWorkitemID) {
		this.backSiteWorkitemID = backSiteWorkitemID;
	}
	/**
	 * 
	 * @return  动态驳回位置的可选的操作员（会签节点)
	 */
	public long getBackSiteOpt() {
		return backSiteOpt;
	}
	/**
	 * 
	 * @return 原操作员
	 */
	public long getSrcOperator() {
		return srcOperator;
	}
	/**
	 * 
	 * @param srcOperator 原操作员
	 */
	public void setSrcOperator(long srcOperator) {
		this.srcOperator = srcOperator;
	}
	/**
	 * 
	 * @param backSiteOpt 动态驳回位置的可选的操作员（会签节点)
	 */
	public void setBackSiteOpt(long backSiteOpt) {
		this.backSiteOpt = backSiteOpt;
	}
	/**
	 * @deprecated 不对二开开放，仅内部使用
	 * @return 直送信息数据
	 */
	public TransitData getTransitData() {
		return transitData;
	}
	/**
	 * @deprecated 不对二开开放，仅内部使用
	 * @param transitData 直送信息数据
	 */
	public void setTransitData(TransitData transitData) {
		this.transitData = transitData;
	}

	@Override
	public void setActiveExecutionNode(IExecutionNode node) {
		setActiveNode((ExecNode) node);
	}

	@Override
	public Env getExecutionEnv() {
		return getEnv();
	}
	
	@Override
	public MidVE getVE() {
		return super.getVE();
	}
	
	public IDBManager getDBManager() throws Throwable{
		return super.getDBManager();
	}
	/**
	 * @deprecated 不对二开开放，仅内部使用
	 * @param handler
	 */
	public void setInputHandler(DataInputOutputHandler handler) {
		inputHandler = handler;
	}
	/**
	 * 获取输入数据的处理器
	 * @deprecated 不对二开开放，仅内部使用
	 * @return 数据输入输出处理器
	 */
	public DataInputOutputHandler getInputHandler() {
		return inputHandler;
	}
	
	/**
	 * 获取输出数据的处理器
	 * @deprecated 不对二开开放，仅内部使用
	 * @return 数据输入输出处理器
	 */
	public DataInputOutputHandler getOutputHandler() {
		return outputHandler;
	}
	
	/**
	 * @deprecated 不对二开开放，仅内部使用
	 * @param handler
	 */
	public void setOutputHandler(DataInputOutputHandler handler) {
		outputHandler = handler;
	}
	
	/**
	 * 从数据输入集合中获取数据项
	 * @param nodeID 节点编号
	 * @param key 数据项标识
	 * @return 数据项
	 * @throws Throwable 
	 */
	public Object getInputData(int nodeID, String key) throws Throwable {
		if (inputHandler != null) {
			return inputHandler.getData(this, nodeID, key);
		}
		return null;
	}
	/**
	 * 获取数据输入集合的所有键
	 * @param nodeID 节点编号
	 * @return 键集合
	 */
	public Set<String> getInputDataKeySet(int nodeID){
		if (inputHandler != null) {
			return inputHandler.keySet(nodeID);
		}
		return new HashSet<>();
	}
	
	/**
	 * 从数据输出集合中获取数据项
	 * @param nodeID 节点编号
	 * @param key 数据项标识
	 * @return 数据项
	 * @throws Throwable 
	 */
	public Object getOutputData(int nodeID, String key) throws Throwable {
		if (outputHandler != null) {
			return outputHandler.getData(this, nodeID, key);
		}
		return null;
	} 
	
	/**
	 * 获取数据输出集合的所有键
	 * @param nodeID 节点编号
	 * @return 键集合
	 */
	public Set<String> getOutputDataKeySet(int nodeID){
		if (outputHandler != null) {
			return outputHandler.keySet(nodeID);
		}
		return new HashSet<>();
	}
	
	public void setAssistanceTask(boolean isAssistanceTask) {
		this.isAssistanceTask = isAssistanceTask;
	}
	
	public boolean isAssistanceTask() {
		return isAssistanceTask;
	}
	
	public void setBatchEndorse(boolean isBatchEndorse) {
		this.isBatchEndorse = isBatchEndorse;
	}
	
	public boolean isBatchEndorse() {
		return isBatchEndorse;
	}
	
	/**
	 * 将上下文中流程的信息清空
	 * @deprecated
	 * */
	public void reset() {
		updateWorkitem = null;
		newWorkitemID = -1l;
		activeBPMInstance = null;
		activeTokenID = -1;
		activeNode = null;
		inlineNode = null;
		isInline = false;
		backSite = "";
		straightSite = -1;
		transitTo = -1;
		backSiteWorkitemID = -1l;
		backSiteOpt = -1l;
		allowTransit = true;
		srcOperator = 0l;
		operationType = -1;
		isRevoke = false;
		revokeWorkitemID = -1l;
		activeParticipator = 0l;
		transitData = null;
		updateCheckerField = true;
		straightEmbedNodeID = -1;
		isAssistanceTask = false;
		isBatchEndorse = false;
		
		//清空doc中的流程数据
		document.removeExpandData(BPMKeys.LoadBPM_KEY);
		document.removeExpandData(BPMKeys.WORKITEM_INFO);
		document.removeExpandData(BPMKeys.RETREAT_CAPTION);
	}
	
	//   merge.erp.revision:59117
	@Override
	public boolean isUpdateModify() {
		return false;
	}
}
