package com.bokesoft.yigo.bpm;

import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yes.bpm.service.cmd.StartInstanceCmd;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;

/**
 * 中间层启动流程的API（API中不包含事务处理的部分）
 * 
 * @author 刘翔翔
 *
 */
public class StartInstance {

	public StartInstance() {
	}

	/**
	 * 启动流程
	 * 
	 * @param context
	 *            上下文
	 * @param doc
	 *            需要启动流程的单据数据
	 * @param formKey
	 *            对应的表单的KEY
	 * @param processKey
	 *            需要启动的流程的KEY(设为空时会自动匹配单据的绑定流程)
	 * 
	 * @throws Throwable
	 */
	public Instance start(DefaultContext context, Document doc, String formKey, String processKey) throws Throwable {
		// 启动流程
		BPMContext bpmContext = new BPMContext(context);
		BPMInstance instance = BPMInstanceFactory.startInstance(bpmContext, doc, processKey, true, formKey);
		bpmContext.getInstanceDataContainer().save();
		return instance;
	}

	/**
	 * 启动流程
	 * 
	 * @param context
	 *            上下文
	 * @param OID
	 *            需要启动流程的单据的OID
	 * @param formKey
	 *            对应的表单的KEY
	 * @param processKey
	 *            需要启动的流程的KEY(设为空时会自动匹配单据的绑定流程)
	 * @throws Throwable
	 */
	public void start(DefaultContext context, long OID, String formKey, String processKey) throws Throwable {
		BPMContext bpmContext = new BPMContext(context);
		StartInstanceCmd cmd = new StartInstanceCmd(formKey, OID, processKey, null);
		cmd.doCmd(bpmContext);
	}
}
