package com.bokesoft.yigo.bpm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.json.JSONObject;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.meta.json.MetaProcessJsonSerializer;
import com.bokesoft.yes.meta.json.MetaProcessJsonUnserializer;
import com.bokesoft.yes.mid.base.MidVEHost;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yigo.common.def.SystemDBField;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.bpm.total.MetaBPM;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.workflow.ProcessSourceType;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;

/**
 * 保存流程到数据库
 * 
 * @author guowj
 *
 */
public class SaveProcessToDB {

	private MetaProcess metaProcess = null;
	
	public SaveProcessToDB() {
		// TODO Auto-generated constructor stub
	}
	
	public SaveProcessToDB(MetaProcess metaProcess) {
		this.metaProcess = metaProcess;
	}
	
	public void setProcess(MetaProcess metaProcess){
		this.metaProcess = metaProcess;
	}
	
	public MetaProcess getProcess(){
		return metaProcess;
	}
	
	/**
	 * 保存流程
	 * 
	 * @param context
	 * @param isSaveAlreadyDeploy 是否可以保存已部署的流程
	 * @throws Throwable
	 */
	public void save(DefaultContext context, boolean isSaveAlreadyDeploy) throws Throwable {
		if(metaProcess == null){
			return;
		}
		saveProcess(context, metaProcess, isSaveAlreadyDeploy);
	}
	
	/**
	 * 保存为新版本的流程
	 * 
	 * @param context
	 * @throws Throwable
	 */
	public void saveNewVersion(DefaultContext context) throws Throwable {
		if(metaProcess == null){
			return;
		}
		MetaProcess newProcess = (MetaProcess) metaProcess.clone();
		String processKey = newProcess.getKey();
		int newVersion = 1;
		PSArgs args = new PSArgs();
		args.addStringArg(processKey);
		IDBManager dbm = context.getDBManager();
		dbm.setRowLock(SystemDBField.BPM_PROCESS, dbm.keyWordEscape(SystemDBField.PROCESSKEY) + "=?", args);
		int version = getVersion(context, processKey);
		if(version > 0){
			newVersion = version + 1;
		}
		newProcess.setVersion(newVersion);
		saveProcess(context, newProcess, false);
	}
	
	private void saveProcess(DefaultContext context, MetaProcess process, boolean isSaveAlreadyDeploy) throws Throwable {
		String processKey = process.getKey();
		String caption = process.getCaption();
		int verID = process.getVersion();
		
		String processString = "";
		MetaProcessJsonSerializer serializer = new MetaProcessJsonSerializer(process, new MidVEHost(context));
		JSONObject processJson = serializer.serialize();
		if(processJson != null){
			processString = processJson.toString();
		}
		
		
		if(!isSaveAlreadyDeploy){
			if(checkDeployExist(context, processKey, verID)){
				throw BPMError.getBPMError(context.getEnv(), BPMError.REPEAT_PROCESS_SAVE, processKey, verID);
			}
		}
		
		IDBManager DBManager = context.getDBManager();
		PreparedStatement ps = null;
		if(checkDBExist(context, processKey, verID)){
			String updateSQL = "update " 
					+ DBManager.keyWordEscape(SystemDBField.BPM_PROCESS) 
					+ " set "
					+ DBManager.keyWordEscape(SystemDBField.DEFINATION) + "=? where "
					+ DBManager.keyWordEscape(SystemDBField.PROCESSKEY) + "=? and "
					+ DBManager.keyWordEscape(SystemDBField.WF_VERID) + "=?";
			try {
				ps = DBManager.preparedUpdateStatement(updateSQL);
				PSArgs args = new PSArgs();
				args.addStringArg(processString);
				args.addStringArg(processKey);
				args.addIntArg(verID);
				DBManager.executeUpdate(ps, updateSQL, args);
			} finally {
				if (ps != null)
					ps.close();
			}
			
		}else{
			Long OID = context.applyNewOID();
			String insertSQL = "insert into " 
					+ DBManager.keyWordEscape(SystemDBField.BPM_PROCESS) 
					+ " ("
					+ DBManager.keyWordEscape(SystemDBField.PROCESSKEY) + ","
					+ DBManager.keyWordEscape(SystemDBField.WF_VERID) + ","
					+ DBManager.keyWordEscape(SystemDBField.CAPTION) + ","
					+ DBManager.keyWordEscape(SystemDBField.DEFINATION) + ","
					+ DBManager.keyWordEscape(SystemDBField.ALREADYDEPLOY) + ","
					+ DBManager.keyWordEscape(SystemDBField.OID) + ") values (?,?,?,?,?,?)";
			try {
				ps = DBManager.preparedUpdateStatement(insertSQL);
				PSArgs args = new PSArgs();
				args.addStringArg(processKey);
				args.addIntArg(verID);
				args.addStringArg(caption);
				args.addStringArg(processString);
				args.addIntArg(0);
				args.addLongArg(OID);
				DBManager.executeUpdate(ps, insertSQL, args);
			} finally {
				if (ps != null)
					ps.close();
			}
		}
		
		// 添加快照
		IMetaFactory factory = context.getVE().getMetaFactory();
		ProcessDefinitionProfile processProfile = new ProcessDefinitionProfile();
		processProfile.setKey(processKey);
		processProfile.setCaption(caption);
		processProfile.setVersion(verID);
		processProfile.setDefinationJson(processJson);
		processProfile.setJsonUnserializer(new MetaProcessJsonUnserializer());
		processProfile.setSourceType(ProcessSourceType.DB);
		factory.getMetaBPM().getProfileMap().put(processKey + "_V" + verID, processProfile);
	}
	
	private int getVersion(DefaultContext context, String nProcessKey) throws Throwable{
		int version = -1;
		// 获取数据库中流程的最新版本
		IDBManager DBManager = context.getDBManager();
		String sql = "select "
				+ DBManager.keyWordEscape(SystemDBField.WF_VERID) 
				+ " from " 
				+ DBManager.keyWordEscape(SystemDBField.BPM_PROCESS)
				+ " where "
				+ DBManager.keyWordEscape(SystemDBField.PROCESSKEY) + " = ? order by "
				+ DBManager.keyWordEscape(SystemDBField.WF_VERID) + " desc";
		PreparedStatement ps = null;
		ResultSet rs = null;
		try {
			ps = DBManager.preparedQueryStatement(sql);
			PSArgs args = new PSArgs();
			args.addStringArg(nProcessKey);
			rs = DBManager.executeQuery(ps, sql, args);
			if(rs.next()){
				version = rs.getInt(1);
			}
		
		} finally {
			if (ps != null)
				ps.close();
			if (rs != null)
				rs.close();
		}
		
		// 检查目录中流程的最新版本
		IMetaFactory factory = context.getVE().getMetaFactory();
		MetaBPM metaBPM = factory.getMetaBPM();
		for(String key : metaBPM.getProfileMap().keySet()){
			String processKey = key.split("_V")[0];
			if(processKey.equalsIgnoreCase(nProcessKey)){
				int profileVersion = TypeConvertor.toInteger(key.split("_V")[1]);
				if(profileVersion > version){
					version = profileVersion;
				}
			}
		}
		
		return version;
	}
	
	private boolean checkDeployExist(DefaultContext context, String processKey, int verID) throws Throwable{
		// 检查数据库中是否存在已部署的流程
		IDBManager DBManager = context.getDBManager();
		String sql = "select "
				+ DBManager.keyWordEscape(SystemDBField.ALREADYDEPLOY) 
				+ " from " 
				+ DBManager.keyWordEscape(SystemDBField.BPM_PROCESS) 
				+ " where "
				+ DBManager.keyWordEscape(SystemDBField.PROCESSKEY) + " = ? and "
				+ DBManager.keyWordEscape(SystemDBField.WF_VERID) + " = ?";
		PreparedStatement ps = null;
		ResultSet rs = null;
		try {
			ps = DBManager.preparedQueryStatement(sql);
			PSArgs args = new PSArgs();
			args.addStringArg(processKey);
			args.addIntArg(verID);
			rs = DBManager.executeQuery(ps, sql, args);
			if(rs.next()){
				if(rs.getInt(1) == 1){
					return true;
				}
			}
		
		} finally {
			if (ps != null)
				ps.close();
			if (rs != null)
				rs.close();
		}
		// 检查目录中是否存在已部署的流程
		IMetaFactory factory = context.getVE().getMetaFactory();
		MetaBPM metaBPM = factory.getMetaBPM();
		if(metaBPM.getMetaBPMDeployInfoCollection().containsKey(processKey)){
			if(verID == metaBPM.getMetaBPMDeployInfoCollection().get(processKey).getVersion()){
				return true;
			}
		}
		
		return false;
	}
	
	private boolean checkDBExist(DefaultContext context, String processKey, int verID) throws Throwable{
		IDBManager DBManager = context.getDBManager();
		String sql = "select * from " 
				+ DBManager.keyWordEscape(SystemDBField.BPM_PROCESS) 
				+ " where "
				+ DBManager.keyWordEscape(SystemDBField.PROCESSKEY) + " = ? and "
				+ DBManager.keyWordEscape(SystemDBField.WF_VERID) + " = ?";
		PreparedStatement ps = null;
		ResultSet rs = null;
		try {
			ps = DBManager.preparedQueryStatement(sql);
			PSArgs args = new PSArgs();
			args.addStringArg(processKey);
			args.addIntArg(verID);
			rs = DBManager.executeQuery(ps, sql, args);
			if(rs.next()){
				return true;
			}
		
		} finally {
			if (ps != null)
				ps.close();
			if (rs != null)
				rs.close();
		}
		return false;
	}
}
