package com.bokesoft.yigo.bpm;

import com.bokesoft.yes.meta.json.MetaProcessJsonUnserializer;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.meta.factory.workflow.ProcessSourceMapContainer;
import com.bokesoft.yigo.meta.factory.workflow.source.IProcessSource;
import com.bokesoft.yigo.meta.factory.workflow.source.ProcessDefinationDB;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class ProcessSourceOperation {

	private String processKey = "";
	private int version = -1;
	
	public ProcessSourceOperation(String processKey, int version) {
		this.processKey = processKey;
		this.version = version;
	}
	
	public void register(DefaultContext context, String processSourcePath) throws Throwable{
		if(processKey.isEmpty() || version == -1){
			return;
		}
		String uniqueKey = processKey + "_V" + version;
		if (processSourcePath == null || processSourcePath.length() == 0){
			return;
		}
		IProcessSource source = (IProcessSource)ReflectHelper.newInstance(context.getVE(), processSourcePath);
		ProcessSourceMapContainer.getInstance().getProcessSourceMap().register(uniqueKey, source);
	}
	
	public IProcessSource getProcessSource(){
		IProcessSource source = null;
		if(processKey.isEmpty() || version == -1){
			return null;
		}
		String uniqueKey = processKey + "_V" + version;
		source = ProcessSourceMapContainer.getInstance().getProcessSourceMap().get(uniqueKey);
		if(source == null){
			source = new ProcessDefinationDB(new MetaProcessJsonUnserializer());
		}
		return source;
	}
}
