package com.bokesoft.yigo.bpm;

import com.bokesoft.yes.bpm.engine.instance.BPMInstance;
import com.bokesoft.yes.bpm.engine.instance.BPMInstanceFactory;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.mid.base.DefaultContext;

/**
 * 关闭指定单据的流程实例的工具类
 * 
 * @author 刘翔翔
 *
 */
public class KillInstance {

	/**
	 * 无参构造器
	 */
	public KillInstance() {
	}

	/**
	 * 关闭流程实例
	 * 
	 * @param context
	 *            上下文
	 * @param OID
	 *            单据OID
	 * @throws Throwable
	 */
	public void killInstance(DefaultContext context, Long OID) throws Throwable {
		BPMContext bpmContext = new BPMContext(context);
		BPMInstance instance = BPMInstanceFactory.getBPMInstanceByOID(bpmContext, OID, true);
		if (instance == null)
			return;
		instance.killInstance(bpmContext);
		bpmContext.getInstanceDataContainer().save();
	}
}
