package com.bokesoft.yes.bpm.meta.transform.elements;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.common.json.JSONSerializable;

public abstract class TransBPMObject implements JSONSerializable{
	/** 节点数字标识 */
	private int id = -1;
	/** 节点字符串标识  */
	private String key = null;
	
	public TransBPMObject() {
		super();
	}
	
	/**
	 * 设置节点数字标识
	 * @param id 数字标识
	 */
	public void setID(int id) {
		this.id = id;
	}
	
	/**
	 * 取得节点数字标识
	 * @return 数字标识
	 */
	public int getID() {
		return this.id;
	}
	
	/**
	 * 设置节点字符串标识
	 * @param key 字符串标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得节点字符串标识
	 * @return 字符串标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 取得对象标记
	 * @return 对象标记，由派性类实现
	 */
	public abstract String getTagName();
	
	public static final String tag_tag_name = "tag-name";
	public static final String tag_id = "id";
	public static final String tag_key = "key";
	public static final String tag_state = "state";
	
	/**
	 * 将对象转换为json格式
	 * @return JSONObject
	 */
	public JSONObject toJSON() throws SerializationException{
		JSONObject json = new JSONObject();
		json.put(tag_tag_name, this.getTagName());
		json.put(tag_id, this.id);
		json.put(tag_key, this.key);
		
		return json;
	}
	
	/**
	 * 从JSON对象读取数据
	 * @param json JSONObject 
	 */
	public void fromJSON(JSONObject json) throws SerializationException{
		this.id = json.optInt(tag_id);
		this.key = json.optString(tag_key);
	}
}
