/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.report.util;

import com.bokesoft.yes.report.output.OutputColor;
import com.bokesoft.yes.report.util.a;
import java.util.Locale;

public class ReportColorUtil {
    private static final int PARSE_COMPONENT = 0;
    private static final int PARSE_PERCENT = 1;
    private static final int PARSE_ANGLE = 2;
    private static final int PARSE_ALPHA = 3;
    private static final OutputColor TRANSPARENT = new OutputColor(0, 0, 0);
    private static final OutputColor ALICEBLUE = new OutputColor(0.9411765f, 0.972549f, 1.0f);
    private static final OutputColor ANTIQUEWHITE = new OutputColor(0.98039216f, 0.92156863f, 0.84313726f);
    private static final OutputColor AQUA = new OutputColor(0.0f, 1.0f, 1.0f);
    private static final OutputColor AQUAMARINE = new OutputColor(0.49803922f, 1.0f, 0.83137256f);
    private static final OutputColor AZURE = new OutputColor(0.9411765f, 1.0f, 1.0f);
    private static final OutputColor BEIGE = new OutputColor(0.9607843f, 0.9607843f, 0.8627451f);
    private static final OutputColor BISQUE = new OutputColor(1.0f, 0.89411765f, 0.76862746f);
    private static final OutputColor BLACK = new OutputColor(0.0f, 0.0f, 0.0f);
    private static final OutputColor BLANCHEDALMOND = new OutputColor(1.0f, 0.92156863f, 0.8039216f);
    private static final OutputColor BLUE = new OutputColor(0.0f, 0.0f, 1.0f);
    private static final OutputColor BLUEVIOLET = new OutputColor(0.5411765f, 0.16862746f, 0.8862745f);
    private static final OutputColor BROWN = new OutputColor(0.64705884f, 0.16470589f, 0.16470589f);
    private static final OutputColor BURLYWOOD = new OutputColor(0.87058824f, 0.72156864f, 0.5294118f);
    private static final OutputColor CADETBLUE = new OutputColor(0.37254903f, 0.61960787f, 0.627451f);
    private static final OutputColor CHARTREUSE = new OutputColor(0.49803922f, 1.0f, 0.0f);
    private static final OutputColor CHOCOLATE = new OutputColor(0.8235294f, 0.4117647f, 0.11764706f);
    private static final OutputColor CORAL = new OutputColor(1.0f, 0.49803922f, 0.3137255f);
    private static final OutputColor CORNFLOWERBLUE = new OutputColor(0.39215687f, 0.58431375f, 0.92941177f);
    private static final OutputColor CORNSILK = new OutputColor(1.0f, 0.972549f, 0.8627451f);
    private static final OutputColor CRIMSON = new OutputColor(0.8627451f, 0.078431375f, 0.23529412f);
    private static final OutputColor CYAN = new OutputColor(0.0f, 1.0f, 1.0f);
    private static final OutputColor DARKBLUE = new OutputColor(0.0f, 0.0f, 0.54509807f);
    private static final OutputColor DARKCYAN = new OutputColor(0.0f, 0.54509807f, 0.54509807f);
    private static final OutputColor DARKGOLDENROD = new OutputColor(0.72156864f, 0.5254902f, 0.043137256f);
    private static final OutputColor DARKGRAY = new OutputColor(0.6627451f, 0.6627451f, 0.6627451f);
    private static final OutputColor DARKGREEN = new OutputColor(0.0f, 0.39215687f, 0.0f);
    private static final OutputColor DARKGREY = DARKGRAY;
    private static final OutputColor DARKKHAKI = new OutputColor(0.7411765f, 0.7176471f, 0.41960785f);
    private static final OutputColor DARKMAGENTA = new OutputColor(0.54509807f, 0.0f, 0.54509807f);
    private static final OutputColor DARKOLIVEGREEN = new OutputColor(0.33333334f, 0.41960785f, 0.18431373f);
    private static final OutputColor DARKORANGE = new OutputColor(1.0f, 0.54901963f, 0.0f);
    private static final OutputColor DARKORCHID = new OutputColor(0.6f, 0.19607843f, 0.8f);
    private static final OutputColor DARKRED = new OutputColor(0.54509807f, 0.0f, 0.0f);
    private static final OutputColor DARKSALMON = new OutputColor(0.9137255f, 0.5882353f, 0.47843137f);
    private static final OutputColor DARKSEAGREEN = new OutputColor(0.56078434f, 0.7372549f, 0.56078434f);
    private static final OutputColor DARKSLATEBLUE = new OutputColor(0.28235295f, 0.23921569f, 0.54509807f);
    private static final OutputColor DARKSLATEGRAY;
    private static final OutputColor DARKSLATEGREY;
    private static final OutputColor DARKTURQUOISE;
    private static final OutputColor DARKVIOLET;
    private static final OutputColor DEEPPINK;
    private static final OutputColor DEEPSKYBLUE;
    private static final OutputColor DIMGRAY;
    private static final OutputColor DIMGREY;
    private static final OutputColor DODGERBLUE;
    private static final OutputColor FIREBRICK;
    private static final OutputColor FLORALWHITE;
    private static final OutputColor FORESTGREEN;
    private static final OutputColor FUCHSIA;
    private static final OutputColor GAINSBORO;
    private static final OutputColor GHOSTWHITE;
    private static final OutputColor GOLD;
    private static final OutputColor GOLDENROD;
    private static final OutputColor GRAY;
    private static final OutputColor GREEN;
    private static final OutputColor GREENYELLOW;
    private static final OutputColor GREY;
    private static final OutputColor HONEYDEW;
    private static final OutputColor HOTPINK;
    private static final OutputColor INDIANRED;
    private static final OutputColor INDIGO;
    private static final OutputColor IVORY;
    private static final OutputColor KHAKI;
    private static final OutputColor LAVENDER;
    private static final OutputColor LAVENDERBLUSH;
    private static final OutputColor LAWNGREEN;
    private static final OutputColor LEMONCHIFFON;
    private static final OutputColor LIGHTBLUE;
    private static final OutputColor LIGHTCORAL;
    private static final OutputColor LIGHTCYAN;
    private static final OutputColor LIGHTGOLDENRODYELLOW;
    private static final OutputColor LIGHTGRAY;
    private static final OutputColor LIGHTGREEN;
    private static final OutputColor LIGHTGREY;
    private static final OutputColor LIGHTPINK;
    private static final OutputColor LIGHTSALMON;
    private static final OutputColor LIGHTSEAGREEN;
    private static final OutputColor LIGHTSKYBLUE;
    private static final OutputColor LIGHTSLATEGRAY;
    private static final OutputColor LIGHTSLATEGREY;
    private static final OutputColor LIGHTSTEELBLUE;
    private static final OutputColor LIGHTYELLOW;
    private static final OutputColor LIME;
    private static final OutputColor LIMEGREEN;
    private static final OutputColor LINEN;
    private static final OutputColor MAGENTA;
    private static final OutputColor MAROON;
    private static final OutputColor MEDIUMAQUAMARINE;
    private static final OutputColor MEDIUMBLUE;
    private static final OutputColor MEDIUMORCHID;
    private static final OutputColor MEDIUMPURPLE;
    private static final OutputColor MEDIUMSEAGREEN;
    private static final OutputColor MEDIUMSLATEBLUE;
    private static final OutputColor MEDIUMSPRINGGREEN;
    private static final OutputColor MEDIUMTURQUOISE;
    private static final OutputColor MEDIUMVIOLETRED;
    private static final OutputColor MIDNIGHTBLUE;
    private static final OutputColor MINTCREAM;
    private static final OutputColor MISTYROSE;
    private static final OutputColor MOCCASIN;
    private static final OutputColor NAVAJOWHITE;
    private static final OutputColor NAVY;
    private static final OutputColor OLDLACE;
    private static final OutputColor OLIVE;
    private static final OutputColor OLIVEDRAB;
    private static final OutputColor ORANGE;
    private static final OutputColor ORANGERED;
    private static final OutputColor ORCHID;
    private static final OutputColor PALEGOLDENROD;
    private static final OutputColor PALEGREEN;
    private static final OutputColor PALETURQUOISE;
    private static final OutputColor PALEVIOLETRED;
    private static final OutputColor PAPAYAWHIP;
    private static final OutputColor PEACHPUFF;
    private static final OutputColor PERU;
    private static final OutputColor PINK;
    private static final OutputColor PLUM;
    private static final OutputColor POWDERBLUE;
    private static final OutputColor PURPLE;
    private static final OutputColor RED;
    private static final OutputColor ROSYBROWN;
    private static final OutputColor ROYALBLUE;
    private static final OutputColor SADDLEBROWN;
    private static final OutputColor SALMON;
    private static final OutputColor SANDYBROWN;
    private static final OutputColor SEAGREEN;
    private static final OutputColor SEASHELL;
    private static final OutputColor SIENNA;
    private static final OutputColor SILVER;
    private static final OutputColor SKYBLUE;
    private static final OutputColor SLATEBLUE;
    private static final OutputColor SLATEGRAY;
    private static final OutputColor SLATEGREY;
    private static final OutputColor SNOW;
    private static final OutputColor SPRINGGREEN;
    private static final OutputColor STEELBLUE;
    private static final OutputColor TAN;
    private static final OutputColor TEAL;
    private static final OutputColor THISTLE;
    private static final OutputColor TOMATO;
    private static final OutputColor TURQUOISE;
    private static final OutputColor VIOLET;
    private static final OutputColor WHEAT;
    private static final OutputColor WHITE;
    private static final OutputColor WHITESMOKE;
    private static final OutputColor YELLOW;
    private static final OutputColor YELLOWGREEN;

    public static OutputColor transOutputColor(String string) {
        if (string == null) {
            throw new NullPointerException("The color components or name must be specified");
        }
        if (string.isEmpty()) {
            return null;
        }
        if ((string = string.toLowerCase(Locale.ROOT)).startsWith("#")) {
            string = string.substring(1);
        } else if (string.startsWith("0x")) {
            string = string.substring(2);
        } else if (string.startsWith("rgb")) {
            if (string.startsWith("(", 3)) {
                return ReportColorUtil.parseRGBColor(string, 4, false);
            }
            if (string.startsWith("a(", 3)) {
                return ReportColorUtil.parseRGBColor(string, 5, true);
            }
        } else if (string.startsWith("hsl")) {
            if (string.startsWith("(", 3)) {
                return ReportColorUtil.parseHSLColor(string, 4, false);
            }
            if (string.startsWith("a(", 3)) {
                return ReportColorUtil.parseHSLColor(string, 5, true);
            }
        } else {
            OutputColor outputColor = a.a(string);
            if (outputColor != null) {
                return outputColor;
            }
        }
        int n = string.length();
        try {
            if (n == 3 || n == 4) {
                n = Integer.parseInt(string.substring(0, 1), 16);
                int n2 = Integer.parseInt(string.substring(1, 2), 16);
                int n3 = Integer.parseInt(string.substring(2, 3), 16);
                return OutputColor.color((int)((int)((double)(n * 255) / 15.0)), (int)((int)((double)(n2 * 255) / 15.0)), (int)((int)((double)(n3 * 255) / 15.0)));
            }
            if (n == 6 || n == 8) {
                n = Integer.parseInt(string.substring(0, 2), 16);
                int n4 = Integer.parseInt(string.substring(2, 4), 16);
                int n5 = Integer.parseInt(string.substring(4, 6), 16);
                return OutputColor.color((int)n, (int)n4, (int)n5);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        throw new IllegalArgumentException("Invalid color specification");
    }

    private static OutputColor parseHSLColor(String string, int n, boolean bl) {
        try {
            int n2;
            int n3 = string.indexOf(44, n);
            int n4 = n3 < 0 ? -1 : string.indexOf(44, n3 + 1);
            int n5 = n4 < 0 ? -1 : (n2 = string.indexOf(bl ? 44 : 41, n4 + 1));
            if ((bl ? (n2 < 0 ? -1 : string.indexOf(41, n2 + 1)) : n2) >= 0) {
                double d = ReportColorUtil.parseComponent(string, n, n3, 2);
                double d2 = ReportColorUtil.parseComponent(string, n3 + 1, n4, 1);
                double d3 = ReportColorUtil.parseComponent(string, n4 + 1, n2, 1);
                return ReportColorUtil.hsb(d, d2, d3);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        throw new IllegalArgumentException("Invalid color specification");
    }

    private static double parseComponent(String string, int n, int n2, int n3) {
        if ((string = string.substring(n, n2).trim()).endsWith("%")) {
            if (n3 > 1) {
                throw new IllegalArgumentException("Invalid color specification");
            }
            n3 = 1;
            string = string.substring(0, string.length() - 1).trim();
        } else if (n3 == 1) {
            throw new IllegalArgumentException("Invalid color specification");
        }
        double d = n3 == 0 ? (double)Integer.parseInt(string) : Double.parseDouble(string);
        switch (n3) {
            case 3: {
                if (d < 0.0) {
                    return 0.0;
                }
                if (d > 1.0) {
                    return 1.0;
                }
                return d;
            }
            case 1: {
                if (d <= 0.0) {
                    return 0.0;
                }
                if (d >= 100.0) {
                    return 1.0;
                }
                return d / 100.0;
            }
            case 0: {
                if (d <= 0.0) {
                    return 0.0;
                }
                if (d >= 255.0) {
                    return 1.0;
                }
                return d / 255.0;
            }
            case 2: {
                if (d < 0.0) {
                    return d % 360.0 + 360.0;
                }
                if (d > 360.0) {
                    return d % 360.0;
                }
                return d;
            }
        }
        throw new IllegalArgumentException("Invalid color specification");
    }

    private static void checkSB(double d, double d2) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Color.hsb's saturation parameter (" + d + ") expects values 0.0-1.0");
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("Color.hsb's brightness parameter (" + d2 + ") expects values 0.0-1.0");
        }
    }

    private static double[] HSBtoRGB(double d, double d2, double d3) {
        d = (d % 360.0 + 360.0) % 360.0 / 360.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (d2 == 0.0) {
            d5 = d6 = d3;
            d4 = d6;
        } else {
            double d7 = d;
            double d8 = (d7 - Math.floor(d7)) * 6.0;
            double d9 = d8 - Math.floor(d8);
            double d10 = d3 * (1.0 - d2);
            double d11 = d3 * (1.0 - d2 * d9);
            double d12 = d3 * (1.0 - d2 * (1.0 - d9));
            switch ((int)d8) {
                case 0: {
                    d4 = d3;
                    d5 = d12;
                    d6 = d10;
                    break;
                }
                case 1: {
                    d4 = d11;
                    d5 = d3;
                    d6 = d10;
                    break;
                }
                case 2: {
                    d4 = d10;
                    d5 = d3;
                    d6 = d12;
                    break;
                }
                case 3: {
                    d4 = d10;
                    d5 = d11;
                    d6 = d3;
                    break;
                }
                case 4: {
                    d4 = d12;
                    d5 = d10;
                    d6 = d3;
                    break;
                }
                case 5: {
                    d4 = d3;
                    d5 = d10;
                    d6 = d11;
                }
            }
        }
        double[] dArray = new double[3];
        double[] dArray2 = dArray;
        dArray[0] = d4;
        dArray2[1] = d5;
        dArray2[2] = d6;
        return dArray2;
    }

    private static OutputColor parseRGBColor(String string, int n, boolean bl) {
        try {
            int n2;
            int n3 = string.indexOf(44, n);
            int n4 = n3 < 0 ? -1 : string.indexOf(44, n3 + 1);
            int n5 = n4 < 0 ? -1 : (n2 = string.indexOf(bl ? 44 : 41, n4 + 1));
            if ((bl ? (n2 < 0 ? -1 : string.indexOf(41, n2 + 1)) : n2) >= 0) {
                double d = ReportColorUtil.parseComponent(string, n, n3, 0);
                double d2 = ReportColorUtil.parseComponent(string, n3 + 1, n4, 0);
                double d3 = ReportColorUtil.parseComponent(string, n4 + 1, n2, 0);
                return OutputColor.color((int)((int)(d * 255.0)), (int)((int)(d2 * 255.0)), (int)((int)(d3 * 255.0)));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        throw new IllegalArgumentException("Invalid color specification");
    }

    private static OutputColor hsb(double d, double d2, double d3) {
        ReportColorUtil.checkSB(d2, d3);
        double[] dArray = ReportColorUtil.HSBtoRGB(d, d2, d3);
        return OutputColor.color((int)((int)(dArray[0] * 255.0)), (int)((int)(dArray[1] * 255.0)), (int)((int)(dArray[2] * 255.0)));
    }

    static /* synthetic */ OutputColor access$100() {
        return ALICEBLUE;
    }

    static /* synthetic */ OutputColor access$200() {
        return ANTIQUEWHITE;
    }

    static /* synthetic */ OutputColor access$300() {
        return AQUA;
    }

    static /* synthetic */ OutputColor access$400() {
        return AQUAMARINE;
    }

    static /* synthetic */ OutputColor access$500() {
        return AZURE;
    }

    static /* synthetic */ OutputColor access$600() {
        return BEIGE;
    }

    static /* synthetic */ OutputColor access$700() {
        return BISQUE;
    }

    static /* synthetic */ OutputColor access$800() {
        return BLACK;
    }

    static /* synthetic */ OutputColor access$900() {
        return BLANCHEDALMOND;
    }

    static /* synthetic */ OutputColor access$1000() {
        return BLUE;
    }

    static /* synthetic */ OutputColor access$1100() {
        return BLUEVIOLET;
    }

    static /* synthetic */ OutputColor access$1200() {
        return BROWN;
    }

    static /* synthetic */ OutputColor access$1300() {
        return BURLYWOOD;
    }

    static /* synthetic */ OutputColor access$1400() {
        return CADETBLUE;
    }

    static /* synthetic */ OutputColor access$1500() {
        return CHARTREUSE;
    }

    static /* synthetic */ OutputColor access$1600() {
        return CHOCOLATE;
    }

    static /* synthetic */ OutputColor access$1700() {
        return CORAL;
    }

    static /* synthetic */ OutputColor access$1800() {
        return CORNFLOWERBLUE;
    }

    static /* synthetic */ OutputColor access$1900() {
        return CORNSILK;
    }

    static /* synthetic */ OutputColor access$2000() {
        return CRIMSON;
    }

    static /* synthetic */ OutputColor access$2100() {
        return CYAN;
    }

    static /* synthetic */ OutputColor access$2200() {
        return DARKBLUE;
    }

    static /* synthetic */ OutputColor access$2300() {
        return DARKCYAN;
    }

    static /* synthetic */ OutputColor access$2400() {
        return DARKGOLDENROD;
    }

    static /* synthetic */ OutputColor access$2500() {
        return DARKGRAY;
    }

    static /* synthetic */ OutputColor access$2600() {
        return DARKGREEN;
    }

    static /* synthetic */ OutputColor access$2700() {
        return DARKGREY;
    }

    static /* synthetic */ OutputColor access$2800() {
        return DARKKHAKI;
    }

    static /* synthetic */ OutputColor access$2900() {
        return DARKMAGENTA;
    }

    static /* synthetic */ OutputColor access$3000() {
        return DARKOLIVEGREEN;
    }

    static /* synthetic */ OutputColor access$3100() {
        return DARKORANGE;
    }

    static /* synthetic */ OutputColor access$3200() {
        return DARKORCHID;
    }

    static /* synthetic */ OutputColor access$3300() {
        return DARKRED;
    }

    static /* synthetic */ OutputColor access$3400() {
        return DARKSALMON;
    }

    static /* synthetic */ OutputColor access$3500() {
        return DARKSEAGREEN;
    }

    static /* synthetic */ OutputColor access$3600() {
        return DARKSLATEBLUE;
    }

    static /* synthetic */ OutputColor access$3700() {
        return DARKSLATEGRAY;
    }

    static /* synthetic */ OutputColor access$3800() {
        return DARKSLATEGREY;
    }

    static /* synthetic */ OutputColor access$3900() {
        return DARKTURQUOISE;
    }

    static /* synthetic */ OutputColor access$4000() {
        return DARKVIOLET;
    }

    static /* synthetic */ OutputColor access$4100() {
        return DEEPPINK;
    }

    static /* synthetic */ OutputColor access$4200() {
        return DEEPSKYBLUE;
    }

    static /* synthetic */ OutputColor access$4300() {
        return DIMGRAY;
    }

    static /* synthetic */ OutputColor access$4400() {
        return DIMGREY;
    }

    static /* synthetic */ OutputColor access$4500() {
        return DODGERBLUE;
    }

    static /* synthetic */ OutputColor access$4600() {
        return FIREBRICK;
    }

    static /* synthetic */ OutputColor access$4700() {
        return FLORALWHITE;
    }

    static /* synthetic */ OutputColor access$4800() {
        return FORESTGREEN;
    }

    static /* synthetic */ OutputColor access$4900() {
        return FUCHSIA;
    }

    static /* synthetic */ OutputColor access$5000() {
        return GAINSBORO;
    }

    static /* synthetic */ OutputColor access$5100() {
        return GHOSTWHITE;
    }

    static /* synthetic */ OutputColor access$5200() {
        return GOLD;
    }

    static /* synthetic */ OutputColor access$5300() {
        return GOLDENROD;
    }

    static /* synthetic */ OutputColor access$5400() {
        return GRAY;
    }

    static /* synthetic */ OutputColor access$5500() {
        return GREEN;
    }

    static /* synthetic */ OutputColor access$5600() {
        return GREENYELLOW;
    }

    static /* synthetic */ OutputColor access$5700() {
        return GREY;
    }

    static /* synthetic */ OutputColor access$5800() {
        return HONEYDEW;
    }

    static /* synthetic */ OutputColor access$5900() {
        return HOTPINK;
    }

    static /* synthetic */ OutputColor access$6000() {
        return INDIANRED;
    }

    static /* synthetic */ OutputColor access$6100() {
        return INDIGO;
    }

    static /* synthetic */ OutputColor access$6200() {
        return IVORY;
    }

    static /* synthetic */ OutputColor access$6300() {
        return KHAKI;
    }

    static /* synthetic */ OutputColor access$6400() {
        return LAVENDER;
    }

    static /* synthetic */ OutputColor access$6500() {
        return LAVENDERBLUSH;
    }

    static /* synthetic */ OutputColor access$6600() {
        return LAWNGREEN;
    }

    static /* synthetic */ OutputColor access$6700() {
        return LEMONCHIFFON;
    }

    static /* synthetic */ OutputColor access$6800() {
        return LIGHTBLUE;
    }

    static /* synthetic */ OutputColor access$6900() {
        return LIGHTCORAL;
    }

    static /* synthetic */ OutputColor access$7000() {
        return LIGHTCYAN;
    }

    static /* synthetic */ OutputColor access$7100() {
        return LIGHTGOLDENRODYELLOW;
    }

    static /* synthetic */ OutputColor access$7200() {
        return LIGHTGRAY;
    }

    static /* synthetic */ OutputColor access$7300() {
        return LIGHTGREEN;
    }

    static /* synthetic */ OutputColor access$7400() {
        return LIGHTGREY;
    }

    static /* synthetic */ OutputColor access$7500() {
        return LIGHTPINK;
    }

    static /* synthetic */ OutputColor access$7600() {
        return LIGHTSALMON;
    }

    static /* synthetic */ OutputColor access$7700() {
        return LIGHTSEAGREEN;
    }

    static /* synthetic */ OutputColor access$7800() {
        return LIGHTSKYBLUE;
    }

    static /* synthetic */ OutputColor access$7900() {
        return LIGHTSLATEGRAY;
    }

    static /* synthetic */ OutputColor access$8000() {
        return LIGHTSLATEGREY;
    }

    static /* synthetic */ OutputColor access$8100() {
        return LIGHTSTEELBLUE;
    }

    static /* synthetic */ OutputColor access$8200() {
        return LIGHTYELLOW;
    }

    static /* synthetic */ OutputColor access$8300() {
        return LIME;
    }

    static /* synthetic */ OutputColor access$8400() {
        return LIMEGREEN;
    }

    static /* synthetic */ OutputColor access$8500() {
        return LINEN;
    }

    static /* synthetic */ OutputColor access$8600() {
        return MAGENTA;
    }

    static /* synthetic */ OutputColor access$8700() {
        return MAROON;
    }

    static /* synthetic */ OutputColor access$8800() {
        return MEDIUMAQUAMARINE;
    }

    static /* synthetic */ OutputColor access$8900() {
        return MEDIUMBLUE;
    }

    static /* synthetic */ OutputColor access$9000() {
        return MEDIUMORCHID;
    }

    static /* synthetic */ OutputColor access$9100() {
        return MEDIUMPURPLE;
    }

    static /* synthetic */ OutputColor access$9200() {
        return MEDIUMSEAGREEN;
    }

    static /* synthetic */ OutputColor access$9300() {
        return MEDIUMSLATEBLUE;
    }

    static /* synthetic */ OutputColor access$9400() {
        return MEDIUMSPRINGGREEN;
    }

    static /* synthetic */ OutputColor access$9500() {
        return MEDIUMTURQUOISE;
    }

    static /* synthetic */ OutputColor access$9600() {
        return MEDIUMVIOLETRED;
    }

    static /* synthetic */ OutputColor access$9700() {
        return MIDNIGHTBLUE;
    }

    static /* synthetic */ OutputColor access$9800() {
        return MINTCREAM;
    }

    static /* synthetic */ OutputColor access$9900() {
        return MISTYROSE;
    }

    static /* synthetic */ OutputColor access$10000() {
        return MOCCASIN;
    }

    static /* synthetic */ OutputColor access$10100() {
        return NAVAJOWHITE;
    }

    static /* synthetic */ OutputColor access$10200() {
        return NAVY;
    }

    static /* synthetic */ OutputColor access$10300() {
        return OLDLACE;
    }

    static /* synthetic */ OutputColor access$10400() {
        return OLIVE;
    }

    static /* synthetic */ OutputColor access$10500() {
        return OLIVEDRAB;
    }

    static /* synthetic */ OutputColor access$10600() {
        return ORANGE;
    }

    static /* synthetic */ OutputColor access$10700() {
        return ORANGERED;
    }

    static /* synthetic */ OutputColor access$10800() {
        return ORCHID;
    }

    static /* synthetic */ OutputColor access$10900() {
        return PALEGOLDENROD;
    }

    static /* synthetic */ OutputColor access$11000() {
        return PALEGREEN;
    }

    static /* synthetic */ OutputColor access$11100() {
        return PALETURQUOISE;
    }

    static /* synthetic */ OutputColor access$11200() {
        return PALEVIOLETRED;
    }

    static /* synthetic */ OutputColor access$11300() {
        return PAPAYAWHIP;
    }

    static /* synthetic */ OutputColor access$11400() {
        return PEACHPUFF;
    }

    static /* synthetic */ OutputColor access$11500() {
        return PERU;
    }

    static /* synthetic */ OutputColor access$11600() {
        return PINK;
    }

    static /* synthetic */ OutputColor access$11700() {
        return PLUM;
    }

    static /* synthetic */ OutputColor access$11800() {
        return POWDERBLUE;
    }

    static /* synthetic */ OutputColor access$11900() {
        return PURPLE;
    }

    static /* synthetic */ OutputColor access$12000() {
        return RED;
    }

    static /* synthetic */ OutputColor access$12100() {
        return ROSYBROWN;
    }

    static /* synthetic */ OutputColor access$12200() {
        return ROYALBLUE;
    }

    static /* synthetic */ OutputColor access$12300() {
        return SADDLEBROWN;
    }

    static /* synthetic */ OutputColor access$12400() {
        return SALMON;
    }

    static /* synthetic */ OutputColor access$12500() {
        return SANDYBROWN;
    }

    static /* synthetic */ OutputColor access$12600() {
        return SEAGREEN;
    }

    static /* synthetic */ OutputColor access$12700() {
        return SEASHELL;
    }

    static /* synthetic */ OutputColor access$12800() {
        return SIENNA;
    }

    static /* synthetic */ OutputColor access$12900() {
        return SILVER;
    }

    static /* synthetic */ OutputColor access$13000() {
        return SKYBLUE;
    }

    static /* synthetic */ OutputColor access$13100() {
        return SLATEBLUE;
    }

    static /* synthetic */ OutputColor access$13200() {
        return SLATEGRAY;
    }

    static /* synthetic */ OutputColor access$13300() {
        return SLATEGREY;
    }

    static /* synthetic */ OutputColor access$13400() {
        return SNOW;
    }

    static /* synthetic */ OutputColor access$13500() {
        return SPRINGGREEN;
    }

    static /* synthetic */ OutputColor access$13600() {
        return STEELBLUE;
    }

    static /* synthetic */ OutputColor access$13700() {
        return TAN;
    }

    static /* synthetic */ OutputColor access$13800() {
        return TEAL;
    }

    static /* synthetic */ OutputColor access$13900() {
        return THISTLE;
    }

    static /* synthetic */ OutputColor access$14000() {
        return TOMATO;
    }

    static /* synthetic */ OutputColor access$14100() {
        return TRANSPARENT;
    }

    static /* synthetic */ OutputColor access$14200() {
        return TURQUOISE;
    }

    static /* synthetic */ OutputColor access$14300() {
        return VIOLET;
    }

    static /* synthetic */ OutputColor access$14400() {
        return WHEAT;
    }

    static /* synthetic */ OutputColor access$14500() {
        return WHITE;
    }

    static /* synthetic */ OutputColor access$14600() {
        return WHITESMOKE;
    }

    static /* synthetic */ OutputColor access$14700() {
        return YELLOW;
    }

    static /* synthetic */ OutputColor access$14800() {
        return YELLOWGREEN;
    }

    static {
        DARKSLATEGREY = DARKSLATEGRAY = new OutputColor(0.18431373f, 0.30980393f, 0.30980393f);
        DARKTURQUOISE = new OutputColor(0.0f, 0.80784315f, 0.81960785f);
        DARKVIOLET = new OutputColor(0.5803922f, 0.0f, 0.827451f);
        DEEPPINK = new OutputColor(1.0f, 0.078431375f, 0.5764706f);
        DEEPSKYBLUE = new OutputColor(0.0f, 0.7490196f, 1.0f);
        DIMGREY = DIMGRAY = new OutputColor(0.4117647f, 0.4117647f, 0.4117647f);
        DODGERBLUE = new OutputColor(0.11764706f, 0.5647059f, 1.0f);
        FIREBRICK = new OutputColor(0.69803923f, 0.13333334f, 0.13333334f);
        FLORALWHITE = new OutputColor(1.0f, 0.98039216f, 0.9411765f);
        FORESTGREEN = new OutputColor(0.13333334f, 0.54509807f, 0.13333334f);
        FUCHSIA = new OutputColor(1.0f, 0.0f, 1.0f);
        GAINSBORO = new OutputColor(0.8627451f, 0.8627451f, 0.8627451f);
        GHOSTWHITE = new OutputColor(0.972549f, 0.972549f, 1.0f);
        GOLD = new OutputColor(1.0f, 0.84313726f, 0.0f);
        GOLDENROD = new OutputColor(0.85490197f, 0.64705884f, 0.1254902f);
        GRAY = new OutputColor(0.5019608f, 0.5019608f, 0.5019608f);
        GREEN = new OutputColor(0.0f, 0.5019608f, 0.0f);
        GREENYELLOW = new OutputColor(0.6784314f, 1.0f, 0.18431373f);
        GREY = GRAY;
        HONEYDEW = new OutputColor(0.9411765f, 1.0f, 0.9411765f);
        HOTPINK = new OutputColor(1.0f, 0.4117647f, 0.7058824f);
        INDIANRED = new OutputColor(0.8039216f, 0.36078432f, 0.36078432f);
        INDIGO = new OutputColor(0.29411766f, 0.0f, 0.50980395f);
        IVORY = new OutputColor(1.0f, 1.0f, 0.9411765f);
        KHAKI = new OutputColor(0.9411765f, 0.9019608f, 0.54901963f);
        LAVENDER = new OutputColor(0.9019608f, 0.9019608f, 0.98039216f);
        LAVENDERBLUSH = new OutputColor(1.0f, 0.9411765f, 0.9607843f);
        LAWNGREEN = new OutputColor(0.4862745f, 0.9882353f, 0.0f);
        LEMONCHIFFON = new OutputColor(1.0f, 0.98039216f, 0.8039216f);
        LIGHTBLUE = new OutputColor(0.6784314f, 0.84705883f, 0.9019608f);
        LIGHTCORAL = new OutputColor(0.9411765f, 0.5019608f, 0.5019608f);
        LIGHTCYAN = new OutputColor(0.8784314f, 1.0f, 1.0f);
        LIGHTGOLDENRODYELLOW = new OutputColor(0.98039216f, 0.98039216f, 0.8235294f);
        LIGHTGRAY = new OutputColor(0.827451f, 0.827451f, 0.827451f);
        LIGHTGREEN = new OutputColor(0.5647059f, 0.93333334f, 0.5647059f);
        LIGHTGREY = LIGHTGRAY;
        LIGHTPINK = new OutputColor(1.0f, 0.7137255f, 0.75686276f);
        LIGHTSALMON = new OutputColor(1.0f, 0.627451f, 0.47843137f);
        LIGHTSEAGREEN = new OutputColor(0.1254902f, 0.69803923f, 0.6666667f);
        LIGHTSKYBLUE = new OutputColor(0.5294118f, 0.80784315f, 0.98039216f);
        LIGHTSLATEGREY = LIGHTSLATEGRAY = new OutputColor(0.46666667f, 0.53333336f, 0.6f);
        LIGHTSTEELBLUE = new OutputColor(0.6901961f, 0.76862746f, 0.87058824f);
        LIGHTYELLOW = new OutputColor(1.0f, 1.0f, 0.8784314f);
        LIME = new OutputColor(0.0f, 1.0f, 0.0f);
        LIMEGREEN = new OutputColor(0.19607843f, 0.8039216f, 0.19607843f);
        LINEN = new OutputColor(0.98039216f, 0.9411765f, 0.9019608f);
        MAGENTA = new OutputColor(1.0f, 0.0f, 1.0f);
        MAROON = new OutputColor(0.5019608f, 0.0f, 0.0f);
        MEDIUMAQUAMARINE = new OutputColor(0.4f, 0.8039216f, 0.6666667f);
        MEDIUMBLUE = new OutputColor(0.0f, 0.0f, 0.8039216f);
        MEDIUMORCHID = new OutputColor(0.7294118f, 0.33333334f, 0.827451f);
        MEDIUMPURPLE = new OutputColor(0.5764706f, 0.4392157f, 0.85882354f);
        MEDIUMSEAGREEN = new OutputColor(0.23529412f, 0.7019608f, 0.44313726f);
        MEDIUMSLATEBLUE = new OutputColor(0.48235294f, 0.40784314f, 0.93333334f);
        MEDIUMSPRINGGREEN = new OutputColor(0.0f, 0.98039216f, 0.6039216f);
        MEDIUMTURQUOISE = new OutputColor(0.28235295f, 0.81960785f, 0.8f);
        MEDIUMVIOLETRED = new OutputColor(0.78039217f, 0.08235294f, 0.52156866f);
        MIDNIGHTBLUE = new OutputColor(0.09803922f, 0.09803922f, 0.4392157f);
        MINTCREAM = new OutputColor(0.9607843f, 1.0f, 0.98039216f);
        MISTYROSE = new OutputColor(1.0f, 0.89411765f, 0.88235295f);
        MOCCASIN = new OutputColor(1.0f, 0.89411765f, 0.70980394f);
        NAVAJOWHITE = new OutputColor(1.0f, 0.87058824f, 0.6784314f);
        NAVY = new OutputColor(0.0f, 0.0f, 0.5019608f);
        OLDLACE = new OutputColor(0.99215686f, 0.9607843f, 0.9019608f);
        OLIVE = new OutputColor(0.5019608f, 0.5019608f, 0.0f);
        OLIVEDRAB = new OutputColor(0.41960785f, 0.5568628f, 0.13725491f);
        ORANGE = new OutputColor(1.0f, 0.64705884f, 0.0f);
        ORANGERED = new OutputColor(1.0f, 0.27058825f, 0.0f);
        ORCHID = new OutputColor(0.85490197f, 0.4392157f, 0.8392157f);
        PALEGOLDENROD = new OutputColor(0.93333334f, 0.9098039f, 0.6666667f);
        PALEGREEN = new OutputColor(0.59607846f, 0.9843137f, 0.59607846f);
        PALETURQUOISE = new OutputColor(0.6862745f, 0.93333334f, 0.93333334f);
        PALEVIOLETRED = new OutputColor(0.85882354f, 0.4392157f, 0.5764706f);
        PAPAYAWHIP = new OutputColor(1.0f, 0.9372549f, 0.8352941f);
        PEACHPUFF = new OutputColor(1.0f, 0.85490197f, 0.7254902f);
        PERU = new OutputColor(0.8039216f, 0.52156866f, 0.24705882f);
        PINK = new OutputColor(1.0f, 0.7529412f, 0.79607844f);
        PLUM = new OutputColor(0.8666667f, 0.627451f, 0.8666667f);
        POWDERBLUE = new OutputColor(0.6901961f, 0.8784314f, 0.9019608f);
        PURPLE = new OutputColor(0.5019608f, 0.0f, 0.5019608f);
        RED = new OutputColor(1.0f, 0.0f, 0.0f);
        ROSYBROWN = new OutputColor(0.7372549f, 0.56078434f, 0.56078434f);
        ROYALBLUE = new OutputColor(0.25490198f, 0.4117647f, 0.88235295f);
        SADDLEBROWN = new OutputColor(0.54509807f, 0.27058825f, 0.07450981f);
        SALMON = new OutputColor(0.98039216f, 0.5019608f, 0.44705883f);
        SANDYBROWN = new OutputColor(0.95686275f, 0.6431373f, 0.3764706f);
        SEAGREEN = new OutputColor(0.18039216f, 0.54509807f, 0.34117648f);
        SEASHELL = new OutputColor(1.0f, 0.9607843f, 0.93333334f);
        SIENNA = new OutputColor(0.627451f, 0.32156864f, 0.1764706f);
        SILVER = new OutputColor(0.7529412f, 0.7529412f, 0.7529412f);
        SKYBLUE = new OutputColor(0.5294118f, 0.80784315f, 0.92156863f);
        SLATEBLUE = new OutputColor(0.41568628f, 0.3529412f, 0.8039216f);
        SLATEGREY = SLATEGRAY = new OutputColor(0.4392157f, 0.5019608f, 0.5647059f);
        SNOW = new OutputColor(1.0f, 0.98039216f, 0.98039216f);
        SPRINGGREEN = new OutputColor(0.0f, 1.0f, 0.49803922f);
        STEELBLUE = new OutputColor(0.27450982f, 0.50980395f, 0.7058824f);
        TAN = new OutputColor(0.8235294f, 0.7058824f, 0.54901963f);
        TEAL = new OutputColor(0.0f, 0.5019608f, 0.5019608f);
        THISTLE = new OutputColor(0.84705883f, 0.7490196f, 0.84705883f);
        TOMATO = new OutputColor(1.0f, 0.3882353f, 0.2784314f);
        TURQUOISE = new OutputColor(0.2509804f, 0.8784314f, 0.8156863f);
        VIOLET = new OutputColor(0.93333334f, 0.50980395f, 0.93333334f);
        WHEAT = new OutputColor(0.9607843f, 0.87058824f, 0.7019608f);
        WHITE = new OutputColor(1.0f, 1.0f, 1.0f);
        WHITESMOKE = new OutputColor(0.9607843f, 0.9607843f, 0.9607843f);
        YELLOW = new OutputColor(1.0f, 1.0f, 0.0f);
        YELLOWGREEN = new OutputColor(0.6039216f, 0.8039216f, 0.19607843f);
    }
}

