import IVBarListener from "./IVBarListener";
import VScrollBar from "./VScrollBar";

/**
 * @author chenbb
 * 
 * 滚动条插件的安装程序
 */
export default class VScrollBarInstaller {

    /** 插件启用数据行数 */
    public static ENABLE_SIZE = 500;
    
    /** 检查当前数据行数是否满足插件安装条件 */
    static checkRowCount(lineCount: number): boolean {
        return lineCount > VScrollBarInstaller.ENABLE_SIZE;
    }

    //判断当前的浏览器环境是否支持html5
    static checkEnv(): boolean {
        return true;
    }

    /**
     * 检查视窗中是否已安装过该插件
     * @param viewAreaEl 
     * @returns 
     */
    static checkInstalled(viewAreaEl: HTMLElement) {
        var elems = viewAreaEl.getElementsByClassName(VScrollBar.CLS_DYNAMIC_SCROLL_BAR);
        return elems && elems.length > 0;
    }

    /**
     * 安装插件
     * @param rowHeight 
     * @param viewAreaEl 
     * @param vbarListener 
     * @returns 
     */
    static install(rowHeight: number, viewAreaEl: HTMLElement, vbarListener: IVBarListener): VScrollBar {
        var vbar = new VScrollBar(rowHeight, viewAreaEl, vbarListener);
        viewAreaEl.appendChild(vbar.getEl());
        return vbar;
    }

    /**
     * 卸载插件
     * @param viewAreaEl 
     * @param vbar 
     */
    static uninstall(viewAreaEl: HTMLElement, vbar: any) {
        if (viewAreaEl && vbar) {
            vbar.unInstall();
            viewAreaEl.removeChild(vbar.getEl());
        }
    }
}