import GridPanelCollapsibleHandlerForH5 from "../layout/handler/GridPanelCollapsibleHandlerForH5";
import GridPanelCollapsibleHandlerForTable from "../layout/handler/GridPanelCollapsibleHandlerForTable";
import GridPanelCollapsibleHandlerForTableVNode from "../layout/handler/GridPanelCollapsibleHandlerForTableVNode";
import GridPanelCollapsibleHandlerForVNode from "../layout/handler/GridPanelCollapsibleHandlerForVNode";
import IAreaCollapsibleHandler from "../layout/handler/IAreaCollapsibleHandler";

export default class PanelUtils {

    static createCollapsibleHandler(panel: YIUI.Panel.GridLayoutPanel): IAreaCollapsibleHandler {
        if (panel.getEl().__IsVirtual) {
            if (YIUI.isDesignMode) {
                return new GridPanelCollapsibleHandlerForTableVNode(panel);
            } else {
                return new GridPanelCollapsibleHandlerForVNode(panel);
            }
        }
        if (panel.getEl().hasClass('ui-glpcss3')) {
            return new GridPanelCollapsibleHandlerForH5(panel);
        } else {
            return new GridPanelCollapsibleHandlerForTable(panel);
        }
    }

    static getGroupItem(groupKey: string, groups: YIUI.IGroupItem[]): YIUI.IGroupItem | null {
        if (!groups) return null;
        for (let group of groups) {
            if (group.key == groupKey) {
                return group;
            }
        }
        return null;
    }
}