import Collapse from "../../../../../common/component/control/Collapse";
import PanelUtils from "../../util/PanelUtils";
import YigoCollapsibleLayoutRender from "../YigoCollapsibleLayoutRender";
import IAreaCollapsibleHandler from "./IAreaCollapsibleHandler";

export default abstract class AbstractGridPanelCollapsibleHandler implements IAreaCollapsibleHandler {

    protected gridPanel: YIUI.Panel.GridLayoutPanel;

    constructor(gridPanel: YIUI.Panel.GridLayoutPanel) {
        this.gridPanel = gridPanel;
    }

    updateAreaCollapse(groupKey: string, bCollapse: boolean): void {
        var gridPanel = this.gridPanel;
        if (!gridPanel.getEl()) return;
        var customLayoutRender = <YigoCollapsibleLayoutRender> gridPanel.customLayoutRender;
        var customLayout = customLayoutRender.getExtraLayout();
        if (!customLayout) return;

        var maxRow: number = gridPanel.getMetaObj().layout.rows.heights;
        var groupItem = PanelUtils.getGroupItem(groupKey, customLayout.groupCollection);
        if (!groupItem) {
            throw new Error("unknow groupkey:" + groupKey);
        }
        var startRow = groupItem.startRow;
        var endRow = groupItem.endRow == undefined ? maxRow: groupItem.endRow;
        for (var row= startRow; row <= endRow; row ++) {
            this.updateRowVisible(row, !bCollapse);
        }
        this.updatePanel();
    }

    abstract renderCollapseControl(control: Collapse): void;

    abstract updateRowVisible(row: number, visible: boolean): void;

    abstract updatePanel(): void;
}