import AbstractLayoutRender from "./AbstractLayoutRender";
import CollapseHandleFactory from '../../../../common/component/factory/CollapseHandleFactory';
import Collapse from '../../../../common/component/control/Collapse';
import { IToggleListener } from "../../../../common/dom/listener/Listeners";
import TypeUtil from "../../../../common/util/TypeUtil";
import IAreaCollapsibleHandler from "./handler/IAreaCollapsibleHandler";
import GridPanelCollapsibleHandlerForH5 from "./handler/GridPanelCollapsibleHandlerForH5";
import PanelUtils from "../util/PanelUtils";
import FormUtils from "../util/FormUtils";

export default class YigoCollapsibleLayoutRender extends AbstractLayoutRender {

    private hanlderControls: Map<string, Collapse> = new Map();

    constructor(panel: YIUI.Panel) {
        super(panel);
    }
    
    doRender(): void {
        if (!this.extraLayout) {
            throw new Error("ExtraLayout undefined!");
        }

        if (this.extraLayout.groupCollection) {
            var needRelayout = false;
            var collapsibleHandler = PanelUtils.createCollapsibleHandler(<YIUI.Panel.GridLayoutPanel> this.panel);
            for (let group of this.extraLayout.groupCollection) {
                var expanded = group.expanded == undefined ? true: group.expanded;
                var uiControl = this.createHandlerControl(group.key, expanded, group.caption, group.handle);
                if (!uiControl) continue;
                collapsibleHandler.renderCollapseControl(uiControl);
                uiControl.setToggleListener(new GroupToggleListener(uiControl.getKey(), collapsibleHandler));
                collapsibleHandler.updateAreaCollapse(uiControl.getKey(), !expanded);
                needRelayout = needRelayout || !expanded; // 收缩节点默认不展开时，高度需要自适应，需要重新显示界面
            }
            if (needRelayout) {
                setTimeout(function (){
                    FormUtils.fireCustomRelayout();
                },1)
            }
        }
    }

    resize(width: number, height: number): void {
    }

    private createHandlerControl(key: string, bExpand: boolean, caption: string, groupControl: YIUI.IGroupControl | undefined): Collapse | null {
        if (!groupControl) return null;
        var uiControl = CollapseHandleFactory.create(groupControl.type, bExpand, caption, groupControl.expandStyleClass, groupControl.collapseStyleClass);
        uiControl.setKey(key);
        var x = groupControl.x < 0 ? 0 : groupControl.x;
        var y = groupControl.y < 0 ? 0 : groupControl.y;
        var xSpan = groupControl.xSpan < 1 ? 1 : groupControl.xSpan;
        var ySpan = groupControl.ySpan < 1 ? 1 : groupControl.ySpan;
        uiControl.setLocation(x, y, xSpan, ySpan);
        var foreColor = groupControl.format?.foreColor;
        uiControl.setTextStyle('color', foreColor ? foreColor : '');
        var font = groupControl.format?.font;
        if (font) {
            uiControl.setTextStyle('font-family', font.name ? font.name : '');
            uiControl.setTextStyle('font-weight', TypeUtil.toBoolean(font.bold) ? 'bold' : '');
            uiControl.setTextStyle('font-font-style', TypeUtil.toBoolean(font.italic) ? 'italic' : '');
            uiControl.setTextStyle('font-size', font.size ? font.size + 'px' : '');
            var strUnderline = font.underline ? 'underline' : '';
            if (strUnderline && font.underlineColor) {
                strUnderline += " " + font.underlineColor;
            }
            uiControl.setTextStyle('text-decoration', strUnderline ? strUnderline : '');
        }
        uiControl.addClass('erp-group-title');
        this.hanlderControls.set(key, uiControl);
        return uiControl;
    }
}


class GroupToggleListener implements IToggleListener {

    private groupKey: string;

    private collapsibleHandler: IAreaCollapsibleHandler;

    constructor(groupKey: string, collapsibleHandler: IAreaCollapsibleHandler) {
        this.groupKey = groupKey;
        this.collapsibleHandler = collapsibleHandler;
    }
    
    toggle(bExpanded: boolean): void {
        this.collapsibleHandler.updateAreaCollapse(this.groupKey, !bExpanded);
        FormUtils.fireCustomRelayout();
        //$(document).trigger('custom.relayout');
    }
    
}