
export default abstract class AbstractLayoutRender {
    
    protected panel: YIUI.Panel;

    protected extraLayout?: YIUI.IExtraLayout;

    constructor(panel: YIUI.Panel) {
        this.panel = panel;
        this.extraLayout = (panel.getMetaObj() ? panel.getMetaObj().extraLayout : undefined);
    }

    getExtraLayout(): YIUI.IExtraLayout | undefined {
        return this.extraLayout;
    }

    abstract doRender(parent: HTMLElement): void;

    abstract resize(width: number, height: number): void;

}