import JComponent from "../../../../common/component/JComponent";
import DivElement from "../../../../common/dom/element/DivElement";

export default class ShadowArea extends JComponent<DivElement> {

    private startRow: number = 0;

    private endRow: number = 0;

    constructor() {
        super(new DivElement());
        this.addClass('area_shadow');
        this.setStyle("position", "absolute");
        this.setStyle("border", "1px dashed #007FFF");
        this.setStyle("opacity", "0.5");
    }

    setStartRow(startRow: number): void {
        this.startRow = startRow;
    }

    getStartRow(): number {
        return this.startRow;
    }

    setEndRow(endRow: number) {
        this.endRow = endRow;
    }

    getEndRow(): number {
        return this.endRow;
    }

    setLocation(left: number, top: number, width: number, height: number) {
        this.setStyle('display', '')
        this.setStyle("left", left + "px");
        this.setStyle("top", top + "px");
        this.setStyle("width", width + "px");
        this.setStyle("height", height + "px");
    }

    hide(): void {
        this.setStyle("left", "-1px");
        this.setStyle("top", "-1px");
        this.setStyle("width", "0px");
        this.setStyle("height", "0px");
        this.setStyle('display', 'none');
    }
}
