import AbstractDomElement from "../../../../common/dom/AbstractDomElement";
import SpanElement from "../../../../common/dom/element/SpanElement";
import AreaStateDelegate from "../state/AreaStateDelegate";
import RectHandle from "./RectHandle";

export default class SelectRange extends AbstractDomElement {

    private areaStateDelegate: AreaStateDelegate;

    private west_Handle: RectHandle = new RectHandle();
    private west_north_Handle: RectHandle = new RectHandle();
    private north_Handle: RectHandle = new RectHandle();
    private north_east_Handle: RectHandle = new RectHandle();
    private east_Handle: RectHandle = new RectHandle();
    private east_south_Handle: RectHandle = new RectHandle();
    private south_Handle: RectHandle = new RectHandle();
    private south_west_Handle: RectHandle = new RectHandle();

    private center_Handle: RectHandle = new RectHandle(false);

    private trashSpan: SpanElement;

    constructor(areaStateDelegate: AreaStateDelegate) {
        super();
        this.areaStateDelegate = areaStateDelegate;
        this.setStyle("position", "absolute");
        this.setStyle("border", "1px solid #007FFF");
        this.setStyle("z-index", "999");
    
        this.west_Handle.addClass("w");
        this.addChild(this.west_Handle);

        this.west_north_Handle.addClassArray(['w', 'n']);
        this.addChild(this.west_north_Handle);

        this.north_Handle.addClass("n");
        this.addChild(this.north_Handle);

        this.north_east_Handle.addClassArray(['n', 'e']);
        this.addChild(this.north_east_Handle);

        this.east_Handle.addClass("e");
        this.addChild(this.east_Handle);

        this.east_south_Handle.addClassArray(['e', 's']);
        this.addChild(this.east_south_Handle);

        this.south_Handle.addClass("s");
        this.addChild(this.south_Handle);

        this.south_west_Handle.addClassArray(['s', 'w']);
        this.addChild(this.south_west_Handle);

        this.center_Handle.setStyle('position', 'absolute');
        this.center_Handle.addClass('cursor_move');
        this.addChild(this.center_Handle);

        this.trashSpan = new SpanElement();
        this.trashSpan.setStyle('position', 'absolute');
        this.trashSpan.addClass('ygrid-icon');
        this.trashSpan.addClass('ui-icon-trash');
        this.addChild(this.trashSpan);

        // 此处$(this.getEl()) 用的是整个选择区域的el,会将选择区域的整个底色变掉
        this.trashSpan.hover(() => this.addClass("ui-state-hover"), () => this.removeClass("ui-state-hover"));
        this.trashSpan.addEventListener("click", (e: MouseEvent) => {
            e.stopPropagation();
            this.areaStateDelegate.getDesignView().doDeleteCmd();
        });
        this.initResizeListener();
    }

    setMoveEnable(b: boolean): void {
        if (b) {
            !this.hasChild(this.center_Handle) && this.addChild(this.center_Handle);
        } else {
            this.removeChild(this.center_Handle);
        }
    }

    private initResizeListener() {
        this.north_Handle.hover(() => {
            this.areaStateDelegate.setTopResizeState();
        },() => {
            if (!this.areaStateDelegate.getCurrentState().isLeftMouseButtonDowning()) {
                this.areaStateDelegate.setNormalState();
            }
        });

        this.south_Handle.hover(() => {
            if (!this.areaStateDelegate.getCurrentState().isLeftMouseButtonDowning()) {
                this.areaStateDelegate.setBottomResizeState();
            }
        },() => {
            if (!this.areaStateDelegate.getCurrentState().isLeftMouseButtonDowning()) {
                this.areaStateDelegate.setNormalState();
            }
        });

        this.center_Handle.hover(() => {
            if (!this.areaStateDelegate.getCurrentState().isLeftMouseButtonDowning()) {
                this.areaStateDelegate.setMoveState();
            }
        }, () => {
            if (!this.areaStateDelegate.getCurrentState().isLeftMouseButtonDowning()) {
                this.areaStateDelegate.setNormalState();
            }
        });
    }

    setSize(width: number, height: number) {
        this.setStyle("width", width + "px");
        this.setStyle("height", height + "px");

        this.west_Handle.setLeft(-1 * RectHandle.HANDLE_SIZE);
        this.west_Handle.setTop((height - RectHandle.HANDLE_SIZE) / 2);

        this.west_north_Handle.setLeft(-1 * RectHandle.HANDLE_SIZE);
        this.west_north_Handle.setTop(-1 * RectHandle.HANDLE_SIZE);

        this.north_Handle.setLeft((width - RectHandle.HANDLE_SIZE) / 2);
        this.north_Handle.setTop(-1 * RectHandle.HANDLE_SIZE);

        this.north_east_Handle.setLeft(width);
        this.north_east_Handle.setTop(-1 * RectHandle.HANDLE_SIZE);
        
        this.east_Handle.setLeft(width);
        this.east_Handle.setTop((height - RectHandle.HANDLE_SIZE) / 2);
        
        this.east_south_Handle.setLeft(width);
        this.east_south_Handle.setTop(height);
        
        this.south_Handle.setLeft((width - RectHandle.HANDLE_SIZE) / 2);
        this.south_Handle.setTop(height);

        this.south_west_Handle.setLeft(-1 * RectHandle.HANDLE_SIZE);
        this.south_west_Handle.setTop(height);

        this.trashSpan.setStyle("left", (width - 20) + "px");
        this.trashSpan.setStyle("top", (height - 20) + "px");

        this.center_Handle.setWidth(width - 2 * RectHandle.HANDLE_SIZE);
        this.center_Handle.setHeight(height - 2 * RectHandle.HANDLE_SIZE);
        this.center_Handle.setStyle("left", RectHandle.HANDLE_SIZE + "px");
        this.center_Handle.setStyle("top", RectHandle.HANDLE_SIZE + "px");
    }

    setVisible(visible: boolean): void {
        visible ? this.setStyle('display', '') : this.setStyle('display', 'none');
    }
}


/******************************* */

/*
<div id="shape_controls" style="left: 564px; top: 91px; width: 139px; height: 88px; z-index: 7;">
<canvas id="controls_bounding" width="159" height="108"></canvas>
<div class="shape_controller n w" index="0" resizedir="tl" style="border-color: rgb(6, 123, 239); width: 6px; height: 6px; z-index: 7; display: block; left: -4px; top: -4px;"></div>
<div class="shape_controller n e" index="1" resizedir="tr" style="border-color: rgb(6, 123, 239); width: 6px; height: 6px; z-index: 7; display: block; left: 135px; top: -4px;"></div>
<div class="shape_controller s e" index="2" resizedir="br" style="border-color: rgb(6, 123, 239); width: 6px; height: 6px; z-index: 7; display: block; left: 135px; top: 84px;"></div>
<div class="shape_controller s w" index="3" resizedir="bl" style="border-color: rgb(6, 123, 239); width: 6px; height: 6px; z-index: 7; display: block; left: -4px; top: 84px;"></div>
<div class="shape_controller w" resizedir="l" style="border-color: rgb(6, 123, 239); width: 6px; height: 6px; z-index: 7; display: none;"></div>
<div class="shape_controller n" resizedir="t" style="border-color: rgb(6, 123, 239); width: 6px; height: 6px; z-index: 7; display: none;"></div>
<div class="shape_controller e" resizedir="r" style="border-color: rgb(6, 123, 239); width: 6px; height: 6px; z-index: 7; display: none;"></div>
<div class="shape_controller s" resizedir="b" style="border-color: rgb(6, 123, 239); width: 6px; height: 6px; z-index: 7; display: none;"></div>
<canvas class="shape_rotater" width="41px" height="40px" style="top: -40px; left: 49px;"></canvas>
<div class="group_icon change_shape_icon" style="display: none;"></div>
</div>
*/