import ICmd from "../../../../common/cmd/ICmd";
import {EExtraLayoutType, EHandleType } from "../../../../common/enum/Enums";
import IXmlEntity from "../../../../common/xml/IXmlEntity";
import ITagNode from "../../../../common/xml/node/ITagNode";
import TagNode from "../../../../common/xml/node/TagNode";
import AreaConstants from "../property/AreaConstants";

export default class NewAreaCmd implements ICmd {

    private key: string;

    private startRow: number = 0;

    private endRow: number = 0;

    private groupTag?: ITagNode;

    private xmlEntity: IXmlEntity;

    constructor(xmlEntity: IXmlEntity, key: string, startRow: number, endRow: number) {
        this.xmlEntity = xmlEntity;
        this.key = key;
        this.startRow = startRow;
        this.endRow = endRow;
    }

    do(): boolean {
        var layoutTag = this.xmlEntity.getRoot().ensureChild(AreaConstants.NODE_ExtraLayout);
        var groupCollectionTag = layoutTag.ensureChild(AreaConstants.NODE_GroupCollection);
        this.groupTag = new TagNode(AreaConstants.NODE_Group);
        this.groupTag.setAttributeValue(AreaConstants.ATTR_Key, this.key);
        this.groupTag.setAttributeValue(AreaConstants.ATTR_StartRow, String(this.startRow));
        this.groupTag.setAttributeValue(AreaConstants.ATTR_EndRow, String(this.endRow));

        if (layoutTag.getAttributeValue(AreaConstants.ATTR_Type, EExtraLayoutType.Collapsible) == EExtraLayoutType.Collapsible) {
            var handleTag = this.groupTag.ensureChild(AreaConstants.NODE_Handle);
            if (this.startRow > 0) {
                handleTag.setAttributeValue(AreaConstants.ATTR_Type, EHandleType.SubAdd);
                handleTag.setAttributeValue(AreaConstants.ATTR_X, "0");
                handleTag.setAttributeValue(AreaConstants.ATTR_Y, String(this.startRow - 1));
                handleTag.setAttributeValue(AreaConstants.ATTR_XSpan, "1", "1");
                handleTag.setAttributeValue(AreaConstants.ATTR_YSpan, "1", "1");
            }
        }
        this.xmlEntity.addNode(this.groupTag, groupCollectionTag);
        return true;
    }

    undo(): void {
        this.groupTag && this.xmlEntity.removeNode(this.groupTag);
    }
}