import ICmd from "../../../../common/cmd/ICmd";
import IXmlEntity from "../../../../common/xml/IXmlEntity";
import ITagNode from "../../../../common/xml/node/ITagNode";
import AreaConstants from "../property/AreaConstants";

export default class ChangeAreaCaptionCmd implements ICmd {

    private tagHandle?: ITagNode;

    private tagArea?: ITagNode;

    private orgCaption?: string;

    private caption: string;

    private xmlEntity: IXmlEntity;

    constructor(xmlEntity: IXmlEntity, caption: string) {
        this.caption = caption;
        this.xmlEntity = xmlEntity;
    }

    do(): boolean {
        var selectable = this.xmlEntity.getSelectionModel().getSingleSeletionItem();
        if (!selectable) return false;
        this.tagHandle = selectable.getTagNode();
        if (this.tagHandle.getTagName() != AreaConstants.NODE_Handle) return false;
        this.tagArea = this.tagHandle.getParent();
        if (this.tagArea) {
            this.orgCaption = this.tagArea.getAttributeValue(AreaConstants.ATTR_Caption);
            this.tagArea.setAttributeValue(AreaConstants.ATTR_Caption, this.caption);
            this.xmlEntity.update(this.tagHandle, true);
            //this.xmlEntity.select(this.tagHandle);
        }
        return true;
    }

    undo(): void {
        var tmpCaption = this.orgCaption ? this.orgCaption : "";
        if (this.tagArea && this.tagHandle) {
            this.tagArea.setAttributeValue(AreaConstants.ATTR_Caption, tmpCaption);
            this.xmlEntity.update(this.tagHandle, true);
            //this.xmlEntity.select(this.tagHandle);
        }
    }

}