import AbstractControl from "../../../common/component/control/AbstractControl";
import TextEditor from "../../../common/component/control/TextEditor";
import { EComponentType } from "../../../common/component/EComponentType";
import IOperatioExecutor from "../../../common/operation/IOperatioExecutor";
import GlobalVariable from "../../../design/GlobalVariable";
import YigoCodeDict from "../control/YigoCodeDict";
import YigoControl from "../control/YigoControl";
import YigoDict from "../control/YigoDict";
import RunDictFormula from '../../../design/base/RunDictFormula';
import { EDesignMode } from "../../../common/enum/Enums";

export default class FormOperationExecutor implements IOperatioExecutor {

    private form: YIUI.UIForm;

    private bEdit = false;

    private context: YIUI.ViewContext;

    private devFormulaID: number = 0;

    private mode = EDesignMode.Dev;

    constructor(form: YIUI.UIForm, mode: EDesignMode) {
        this.form = form;
        this.mode = mode;
        this.context = new YIUI.ViewContext(this.form);
    }

    getMode(): EDesignMode {
        return this.mode;
    }

    createYigoControl(key: string, type: string, component: any): AbstractControl<any> {
        var dict = this.getComponent(key);
        if (!dict) return new TextEditor();

        var $el = dict.el;
        $el.css("margin-left", 0);
        var $input = $('input', $el);
        $input.width(dict.el.width());
        $input.height(dict.el.height());
            
        switch (type) {
            case EComponentType.YigoDict:
                return new YigoDict(dict, dict.el[0]);
            case EComponentType.YigoCodeDict:
                return new YigoCodeDict(dict, dict.el[0], this);
            case EComponentType.YigoControl:
                return new YigoControl(component, this);
        }
        return new TextEditor();
    }

    async queryFormulaDictName(dictID: number): Promise<string> {
        return await this.eval(`GetDictValue('${GlobalVariable.G_FORMULA_DICT}', ${dictID}, 'Name')`);
    }

    async queryDictID(dictKey: string, code: string): Promise<number> {
        return await this.eval(`GetDictOID('${dictKey}', 'Code', '${code}')`);
    }

    async queryFormulaDictID(strFormula: string): Promise<number> {
        if (!strFormula) return -1;
        var dictFormula: RunDictFormula | undefined = RunDictFormula.parse(strFormula);
        if (dictFormula) {
            return await this.eval(`GetDictOID('${dictFormula.getDictKey()}', 'Code', '${dictFormula.getCode()}')`);
        } else {
            if (!this.devFormulaID) {
                return await this.eval(`GetDictOID('${GlobalVariable.G_FORMULA_DICT}', 'Code', '${GlobalVariable.G_DevelopCode}')`);
            }
            return this.devFormulaID;
        }
    }

    isDevFormulaID(devFormulaID: number): boolean {
        return this.devFormulaID == devFormulaID;
    }

    setEditable(b: boolean): void {
        this.bEdit = b;
    }

    isEditable(): boolean {
        return this.bEdit;
    }

    getForm(): any {
        return this.form;
    }

    async isReadOnly(): Promise<boolean> {
        return await this.form.eval(`ReadOnly()`, {form: this.form}, null);
    }

    getComponent(key: string): any {
        return this.form.getComponent(key);
    }

    async eval(exp: string): Promise<any> {
        return await this.form.eval(exp, this.context, null);
    }

    async asyncEval(exp: string): Promise<any> {
        return await this.form.asyncEval(exp, this.context, null);
    }

    create(): void {
        this.eval(`New('${this.form.getFormKey()}')`);
    }

    edit(): void {
        this.eval(`Edit()`);
    }

    save(xml: string): void {
        //this.workflowFieldKey && this.form.setComponentValue(this.workflowFieldKey, xml, true);
        this.eval(`Save()`);
        this.edit();
    }

    load(xml: string): void {
        //throw new Error("Method not implemented.");
    }

    delete(): void {
    }
    
}