import AbstractDomElement from "../../../../../common/dom/AbstractDomElement";
import ITagNode from "../../../../../common/xml/node/ITagNode";
import BaseConstants from "../../../../base/BaseConstants";
import IPrintElementView from "../IPrintElementView";
import JComponent from "../../../../../common/component/JComponent";
import PrintEmbedLayout from "./PrintEmbedLayout";
import DomUtil from "../../../../../common/dom/DomUtil";

export abstract class AbstractEmbedView extends JComponent<PrintEmbedLayout> implements IPrintElementView {
    
    private tagNode: ITagNode;

    constructor(tagNode: ITagNode) {
        super(new PrintEmbedLayout([], 0));
        this.tagNode = tagNode;
    }

    findChildNode(tagNode: ITagNode): IPrintElementView | null {
        return null;
    }

    updateView(): void {
        // 更新视图状态，包括选择
    }


    isEmbed(): boolean {
        return true;
    }

    getTagNode(): ITagNode {
        return this.tagNode;
    }

    getX(): number {
        return this.tagNode.getAttributeValueInt(BaseConstants.ATTR_X, 0);
    }

    getY(): number {
        return this.tagNode.getAttributeValueInt(BaseConstants.ATTR_Y, 0);
    }


    containPoint(x: number, y: number): boolean {
        var offset = DomUtil.offsetParent(this.getEl());
        var top = offset.offsetTop;
        var left = offset.offsetLeft;
        var width = this.getDomElement().getHtmlClientWidth();
        var height = this.getDomElement().getHtmlClientHeight();
        return x >= left && x <= (left + width)
            && y >= top && y <= (top + height);
    }

}


