import JComponent from "../../../../common/component/JComponent";
import DomUtil from "../../../../common/dom/DomUtil";
import SpanElement from "../../../../common/dom/element/SpanElement";
import TableLayout from "../../../../common/dom/element/TableLayout";
import SizeInfo from "../../../../common/struct/SizeInfo";
import INode from "../../../../common/xml/node/INode";
import ITagNode from "../../../../common/xml/node/ITagNode";
import BaseConstants from "../../../base/BaseConstants";
import PRINT from "../../base/PRINT";
import PrintConstants from "../../base/PrintConstants";
import {CellView} from "./CellView";
import IPrintElementView from './IPrintElementView';
import TableCellLocation from "../../../../common/struct/TableCellLocation";
import Span from "../../../../common/component/control/Span";
import PrintOptStateDelegate from "../../state/PrintOptStateDelegate";
import PrintNodeUtil from "../../util/PrintNodeUtil";
import PrintTableLayout from "./PrintTableLayout";
import {ExcelCellView} from "../../../excel/view/element/ExcelCellView";

export default class SectionView extends JComponent<PrintTableLayout> implements IPrintElementView {

    private tagNode: ITagNode;

    private tableElement: PrintTableLayout;

    constructor(tagNode: ITagNode){
        super(new PrintTableLayout([], 0));
        this.tagNode = tagNode;
        this.tableElement = this.getDomElement();
        this.tableElement.init(this.getColumns(), 0);
        this.tableElement.addClass('layout');
        this.buildRows();
    }

    updateView(): void {
        //更新选中状态
        this.getTagNode().isSelected() ? this.addClass('selected') : this.removeClass('selected');
    }

    findChildNode(tagNode: ITagNode): IPrintElementView | null {
        for (var row=0; row<=this.tableElement.getLastRowIndex(); row++) {
            for (var col=0; col<=this.tableElement.getLastColumnIndex(); col++) {
                var cell = this.tableElement.getCellAt(row, col);
                var cellView = <CellView> cell.getContent();
                if (cellView && cellView.getTagNode() == tagNode) {
                    return cellView;
                }
            }
        }
        return null;
    }

    isEmbed(): boolean {
        return false;
    }

    getTagNode(): ITagNode {
        return this.tagNode;
    }

    containPoint(x: number, y: number): boolean {
        var offset = DomUtil.offsetParent(this.getEl());
        var top = offset.offsetTop;
        var left = offset.offsetLeft;
        var width = this.getDomElement().getHtmlClientWidth();
        var height = this.getDomElement().getHtmlClientHeight();
        return x >= left && x <= (left + width)
            && y >= top && y <= (top + height);
    }

    locCell(x: number, y: number): CellView | null {
        var cellLocation = new TableCellLocation(x, y);
        if (cellLocation) {
            var cell = this.tableElement.getCell(cellLocation);
            return <CellView> cell.getContent();
        }
        return null;
    }
    getLastColumnIndex(): number {
        return this.tableElement.getLastColumnIndex();
    }
    getChildCell(row: number, col: number): any | null {
        return this.tableElement.getCellAt(row, col);
    }
    getChildNode(row: number, col: number): CellView | null {
        var cell = this.tableElement.getCellAt(row, col);

        return <CellView>cell.getContent();
    }
    getLastRowIndex(): number {
        return this.tableElement.getLastRowIndex();
    }
    locMultiCell(x: number, y: number): CellView | null {
        var cellLocation = this.tableElement.hitCell(x, y);
        if (cellLocation) {
            var cell = this.tableElement.getCell(cellLocation);
            return <CellView> cell.getContent();
        }
        return null;
    }

    getColumns(): number[] {
        var columnWidths = [];
        var tagColumnsNode = this.tagNode.getChild(PrintConstants.NODE_Columns);
        var tagColumns: INode[] | undefined = tagColumnsNode?.getChildren();
        if (tagColumns) {
            for (let column of tagColumns) {
                var tagColumn = <ITagNode> column;
                columnWidths.push(tagColumn.getAttributeValueInt(BaseConstants.ATTR_Width, PRINT.D_COLUMN_WIDTH));
            }
        }
        return columnWidths;
    }

    buildRows() {
        var tagRowsNode = this.tagNode.getChild(PrintConstants.NODE_Rows);
        var tagRows: INode[] | undefined = tagRowsNode?.getChildren();
        if (tagRows) {
            for (var rowindex=0; rowindex<tagRows.length; rowindex ++) {
                var tagRow = <ITagNode> tagRows[rowindex];
                var rowElement = this.tableElement.addRow(tagRow.getAttributeValueInt(BaseConstants.ATTR_Height, PRINT.D_ROW_HEIGHT));
                var tagCells = tagRow.getChildren();
                let rowHeight:number =   tagRow.getAttributeValueInt(BaseConstants.ATTR_Height,PRINT.D_ROW_HEIGHT);
                for (var colindex=0; colindex<tagCells.length; colindex ++) {
                    var tagCell = <ITagNode> tagCells[colindex];
                    var cellView = new CellView(tagCell,rowindex,colindex);
                    var rowele = rowElement.getCell(colindex);
                    if (!rowele){
                        continue;
                    }
                    rowele.setStyle("position", "relative");
                    let columnDrag = rowele.getColumnDrag();
                   columnDrag.setStyle("height",rowHeight.toString()+"px")
                    let rowRrag = rowele.getRowRrag();
                    let sectionNode = tagRow.getParent()!.getParent()!;
                    let child = <ITagNode>sectionNode.getChildren()[0];
                    let columns = child.getChildren();
                    let column = <ITagNode>columns[colindex];
                    let columnWidth:number = Number(column.getAttributeValue(BaseConstants.ATTR_Width));
                    if (tagCell.getAttributeValue(PrintConstants.ATTR_IsMergedHead) && tagCell.getAttributeValue(PrintConstants.ATTR_IsMergedHead) == "true"){
                        let columnSpan :number= Number(tagCell.getAttributeValue(PrintConstants.ATTR_MergedColumnSpan));
                        let length :number = 0;
                        let index : number = colindex;
                        for (let i = 0; i < columnSpan; i++) {
                            let  col = <ITagNode>columns[colindex];
                            length = length +Number(col.getAttributeValue(BaseConstants.ATTR_Width));
                            index++;
                        }
                        rowRrag.setStyle("width",length.toString()+"px");
                    }else {
                        rowRrag.setStyle("width",columnWidth+"px");

                    }
                   rowElement.setCellElement(colindex, cellView);
                    cellView.updateView();

                }
            }
        }
    }

    createCellSpan(tagCell: ITagNode): SpanElement {
        var span = new SpanElement(tagCell.getAttributeValue(BaseConstants.ATTR_Caption));
        return span;
    }

    getWidth(): SizeInfo {
        return SizeInfo.valueOfPX(this.tableElement.getWidth());
    }

    getHeight(): SizeInfo {
        return SizeInfo.valueOfPX(this.tableElement.getHeight());
    }
}