import OperationDispatcher from "../../../common/operation/OperationDispatcher";
import SizeInfo from "../../../common/struct/SizeInfo";
import AbstractDesignView from "../../base/AbstractDesignView";
import ComplexDesignView from "../../base/ComplexDesignView";
import DesignVariable from "../../base/DesignVariable";
import DevPropertyPlugin from "../../bpm/property/DevPropertyPlugin";
import PropertyPlugin from "../../plugin/property/PropertyPlugin";
import PropertyUIContainer from "../../plugin/property/ui/PropertyUIContainer";
import PrintConstants from "../base/PrintConstants";
import PrintPropertyDefine from "../base/PrintPropertyDefine";
import PrintGraphicView from "./PrintGraphicView";
import PrintToolbar from "./PrintToolbar";

/**
 * 打印设计组合视图，用于组合属性面板，以及设计视图
 */
export default class PrintDesignView extends AbstractDesignView<DevPropertyPlugin> {

    private viewContainer: ComplexDesignView<PrintGraphicView, PrintToolbar>;

    private propertyPlugin: PropertyPlugin;

    constructor(viewContainer: ComplexDesignView<PrintGraphicView, PrintToolbar>, optDispatcher: OperationDispatcher) {
        super(DesignVariable.D_PROPERTY_WIDTH, new PropertyUIContainer(new DevPropertyPlugin(optDispatcher)));
        this.viewContainer = viewContainer;
        this.propertyPlugin = this.propertyUIContainer.getPropertyPlugin();

        this.propertyUIContainer.setStyle('float', 'right');
        this.setCenter(viewContainer);
        this.setRight(this.propertyUIContainer);
      
        var PD = PrintPropertyDefine.getInstance();
        this.propertyPlugin.register(PrintConstants.NODE_Report, PD.getPropertyDefines(PrintConstants.NODE_Report));
        this.propertyPlugin.register(PrintConstants.NODE_Section, PD.getPropertyDefines(PrintConstants.NODE_Section));
        this.propertyPlugin.register(PrintConstants.NODE_Column, PD.getPropertyDefines(PrintConstants.NODE_Column));
        this.propertyPlugin.register(PrintConstants.NODE_Row, PD.getPropertyDefines(PrintConstants.NODE_Row));

        var cellPropertyGroups = PD.getPropertyDefinesByTypes([PrintConstants.NODE_Cell, PrintConstants.NODE_Row, PrintConstants.NODE_Column, PrintConstants.NODE_Section]);
        this.propertyPlugin.register(PrintConstants.NODE_Cell, cellPropertyGroups);
    }

    resize(parentWidth: number, parentHeight: number) {
        var width = parentWidth -  DesignVariable.D_PROPERTY_WIDTH;
        this.viewContainer.resize(width, parentHeight);
        this.propertyUIContainer.setHeight(SizeInfo.valueOfPX(parentHeight));
    }
}